/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.webmacro.util.Constant;

public final class Log {
    public static final boolean debug = true;
    private static final Vector logsRegistered = new Vector();
    private static Hashtable typesEnabled = null;
    public static final Constant NONE = new Constant("NONE", 0);
    public static final Constant ERROR = new Constant("ERROR", 1);
    public static final Constant WARNING = new Constant("WARNING", 2);
    public static final Constant INFO = new Constant("INFO", 3);
    public static final Constant EXCEPTION = new Constant("EXCEPTION", 4);
    public static final Constant DEBUG = new Constant("DEBUG", 5);
    public static final Constant ALL = new Constant("ALL", 6);
    private static final String TYPE_ENABLED = "ENABLED";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static int myLevel = INFO.getOrder();
    private static PrintWriter myTarget = new PrintWriter(System.out, true);
    private static boolean iTraceExceptions = false;
    private static DateFormat dateFmt = DateFormat.getDateTimeInstance(3, 3);
    private static boolean isLogFilePerDay = false;
    private static SimpleDateFormat _logFileSuffix = new SimpleDateFormat("_yyyyMMdd");
    private static String _prevLogDate = "";
    private static String _logDate = "";
    private static String _orgLogFile = "";
    private static SimpleDateFormat _logFileDateFormat = null;
    private static String _dateTime;
    private String logType;
    private String logDescr;
    private StringBuffer myErrors = null;

    public static final Constant getConstant(int n) {
        Constant constant;
        switch (n) {
            case 0: {
                constant = NONE;
                break;
            }
            case 1: {
                constant = ERROR;
                break;
            }
            case 2: {
                constant = WARNING;
                break;
            }
            case 3: {
                constant = INFO;
                break;
            }
            case 4: {
                constant = EXCEPTION;
                break;
            }
            case 5: {
                constant = DEBUG;
                break;
            }
            case 6: {
                constant = ALL;
                break;
            }
            default: {
                constant = n < 0 ? NONE : ALL;
            }
        }
        return constant;
    }

    public static final Constant getConstant(String string) {
        Constant constant = string.equalsIgnoreCase(NONE.getName()) ? NONE : (string.equalsIgnoreCase(ERROR.getName()) ? ERROR : (string.equalsIgnoreCase(WARNING.getName()) ? WARNING : (string.equalsIgnoreCase(INFO.getName()) ? INFO : (string.equalsIgnoreCase(EXCEPTION.getName()) ? EXCEPTION : (string.equalsIgnoreCase(DEBUG.getName()) ? DEBUG : ALL)))));
        return constant;
    }

    public static final void setLogFileEachDay(boolean bl) {
        isLogFilePerDay = bl;
    }

    public static final void setLogFileDateFormat(String string) {
        _logFileDateFormat = new SimpleDateFormat(string);
    }

    public static final void setLevel(Constant constant) {
        myLevel = constant.getOrder();
        myTarget.println("*** LOG LEVEL SET TO: " + constant);
    }

    public static final void setTarget(PrintWriter printWriter) {
        if (printWriter == null) {
            printWriter = new PrintWriter(new OutputStreamWriter(System.err));
        }
        myTarget = printWriter;
        _dateTime = dateFmt.format(new Date());
        if (_logFileDateFormat != null) {
            _dateTime = _logFileDateFormat.format(new Date());
        }
        myTarget.println("*** BEGIN: " + _dateTime + " ***");
    }

    public static final void setTarget(OutputStream outputStream) {
        Log.setTarget(outputStream == null ? null : new PrintWriter(new OutputStreamWriter(outputStream)));
    }

    public static final void setTarget(String string) throws IOException {
        PrintWriter printWriter;
        if (string != null) {
            if (isLogFilePerDay) {
                _orgLogFile = string;
                _prevLogDate = _logDate = Log.getLogFileSuffix();
                string = string + _logDate;
            }
            printWriter = new PrintWriter(new FileWriter(string, true));
        } else {
            printWriter = new PrintWriter(new OutputStreamWriter(System.err));
        }
        Log.setTarget(printWriter);
        printWriter.flush();
    }

    public static final void traceExceptions(boolean bl) {
        iTraceExceptions = bl;
    }

    private static final void write(String string, String string2, Object object) {
        if (typesEnabled != null && typesEnabled.get(string2) != TYPE_ENABLED) {
            return;
        }
        try {
            if (isLogFilePerDay && !(_logDate = Log.getLogFileSuffix()).equals(_prevLogDate)) {
                Log.setTarget(_orgLogFile);
            }
            _dateTime = dateFmt.format(new Date());
            if (_logFileDateFormat != null) {
                _dateTime = _logFileDateFormat.format(new Date());
            }
            myTarget.print(_dateTime + "\t" + string2 + "\t" + string + "\t" + object);
            myTarget.flush();
        }
        catch (Exception exception) {
            System.err.println("** COULD NOT WRITE LOG! SWITCHING TO STDERR **");
            System.err.println(dateFmt.format(new Date()) + "\t" + string + "\t" + object);
            System.err.flush();
            Log.setTarget(new PrintWriter(System.err));
        }
    }

    private static final void writeln(String string, String string2, Object object) {
        Log.write(string, string2, object + NEWLINE);
    }

    public static final Enumeration getTypes() {
        return logsRegistered.elements();
    }

    public static final Enumeration getTypesEnabled() {
        if (typesEnabled == null) {
            return logsRegistered.elements();
        }
        return typesEnabled.keys();
    }

    public static final void enableTypes(String[] stringArray) {
        Log.disableAllTypes();
        int n = 0;
        while (n < stringArray.length) {
            Log.enableType(stringArray[n]);
            ++n;
        }
    }

    public static final void enableType(String string) {
        Hashtable hashtable = typesEnabled;
        if (typesEnabled == null) {
            return;
        }
        hashtable.put(string, TYPE_ENABLED);
    }

    public static final void enableAllTypes() {
        typesEnabled = null;
    }

    public static final void disableAllTypes() {
        typesEnabled = new Hashtable();
    }

    public Log(String string, String string2) {
        this.logType = string.intern();
        this.logDescr = string2;
        logsRegistered.addElement(this);
    }

    public final void error(Object object) {
        if (myLevel >= ERROR.getOrder()) {
            Log.writeln("ERROR", this.logType, object);
        }
    }

    public final void warning(Object object) {
        if (myLevel >= WARNING.getOrder()) {
            if (this.myErrors != null) {
                this.myErrors.append(object);
                this.myErrors.append("\r\n");
            }
            Log.writeln("WARN", this.logType, object);
        }
    }

    public final void info(Object object) {
        if (myLevel >= INFO.getOrder()) {
            Log.writeln("INFO", this.logType, object);
        }
    }

    public final void exception(Object object) {
        if (myLevel < EXCEPTION.getOrder()) {
            return;
        }
        if (iTraceExceptions && object instanceof Exception) {
            Exception exception = (Exception)object;
            if (this.myErrors != null) {
                this.myErrors.append(exception);
                this.myErrors.append("\r\n");
            }
            Log.write("EXCPT", this.logType, "");
            exception.printStackTrace(myTarget);
            myTarget.flush();
        } else {
            Log.writeln("EXCPT", this.logType, object);
        }
    }

    public final void debug(Object object) {
        if (myLevel >= DEBUG.getOrder()) {
            Log.writeln("DEBUG", this.logType, object);
        }
    }

    private static String getLogFileSuffix() {
        String string = _logFileSuffix.format(Calendar.getInstance().getTime());
        return string;
    }

    public String getErrors() {
        return this.myErrors != null ? this.myErrors.toString() : "(error tracking disabled)";
    }

    public void initErrorTracking(boolean bl) {
        this.myErrors = bl ? new StringBuffer() : null;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("Logging to \"log\" in the current directory.");
            Log.setTarget("log");
            Log log = new Log("testing", "just used for testing");
            int n = NONE.getOrder();
            while (n <= ALL.getOrder()) {
                Log.setLevel(Log.getConstant(n));
                log.error("Testing error");
                log.warning("This is a warning");
                log.info("This is informative.");
                log.exception("An exception");
                log.debug("Debug junk");
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

