/* ------------------------------------------------------------------------
 * $Id: GeometryImpl.hh,v 1.16 2001/07/23 20:02:51 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-06-15 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2000 Steve Houston <shouston@programmer.net>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _GeometryImpl_hh_
#define _GeometryImpl_hh_

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Polhem/EmitterImpl.hh"
#include "Nobel/Geometry.hh"

// -- Forward Declarations
class Mutex;
class VolumeImpl;

// -- Class Declarations

class GeometryImpl : public virtual POA_Nobel::Geometry,
		     public EmitterImpl {
    
public:

    /**
     * Constructor.
     **/
    GeometryImpl();

    /**
     * Destructor.
     **/
    virtual ~GeometryImpl();
    
    // IDL Operations
    virtual void render(Nobel::Renderer_ptr r) = 0;
    virtual CORBA::Long getVertexNumber() { return _vertexNumber; }
    virtual void setVertexNumber(CORBA::Long) = 0;
    virtual void setVertex(CORBA::Long index, const Nobel::Vertex3D &v) = 0;
    virtual Nobel::Vertex3D getVertex(CORBA::Long index) = 0;
    virtual Nobel::Volume_ptr getBoundingVolume();
    
protected:
    	
    template <class T>
    void updateLimit(int &limit, int value, T &seq);

    void findMinMax(const Nobel::Vertex3DSeq &vs, int vertexNumber,
		    Nobel::Vertex3D &minimum, Nobel::Vertex3D &maximum);
    
    /**
     * Recompute bounding volume. This will step through all the
     * vertices in the geometry and recreate the bounding volume for
     * it.
     **/
    virtual void recomputeBoundingVolume() = 0;

    int _vertexNumber;
    bool _dirty;
    VolumeImpl *_bounds;
    Mutex _mutex;
};


class FaceGeometryImpl : public virtual POA_Nobel::FaceGeometry,
			 public GeometryImpl {
    
public:

    /**
     * Constructor.
     **/
    FaceGeometryImpl();

    /**
     * Destructor.
     **/
    virtual ~FaceGeometryImpl();

    // IDL Operations
    virtual void render(Nobel::Renderer_ptr r) = 0;
    //virtual CORBA::Long getVertexNumber() { return _vertexNumber; }
    //virtual void setVertexNumber(CORBA::Long n) = 0;

    virtual void setNormalNumber(CORBA::Long n) = 0;
    virtual void setTexCoordNumber(CORBA::Long n) = 0;
    virtual void setFaceNumber(CORBA::Long n) = 0;

    virtual CORBA::Long getNormalNumber() { return _normalNumber; }
    virtual CORBA::Long getTexCoordNumber() { return _texCoordNumber; }
    virtual CORBA::Long getFaceNumber() { return _faceNumber; }
    
    virtual void setTexCoord(CORBA::Long index, const Nobel::TexCoord &tc) = 0;
    virtual Nobel::TexCoord getTexCoord(CORBA::Long index) = 0;
    virtual void setNormal(CORBA::Long index, const Nobel::Vertex3D &n) = 0;
    virtual Nobel::Vertex3D getNormal(CORBA::Long index) = 0;
    
protected:
    int _normalNumber;
    int _texCoordNumber;
    int _faceNumber;
};    

#endif /* GeometryImpl.hh */

