/* ------------------------------------------------------------------------
 * $Id: InputDevice.hh,v 1.2 2001/07/18 07:47:49 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-21 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _InputDevice_hh_
#define _InputDevice_hh_

// -- 3Dwm Includes
#include "Celsius/Runnable.hh"
#include "Polhem/Platform.hh"

/**
 * General input device interface.
 **/
class InputDevice : public Runnable {
public:
    
    /**
     * Constructor.
     *
     * @param eventQueue pointer to the event queue to use.
     **/
    InputDevice(InputEventQueue *eventQueue)
	: _eventQueue(eventQueue) { }

    /**
     * Destructor.
     **/
    virtual ~InputDevice() { }

    /**
     * Retrieve the name of the input device.
     *
     * @return device name string.
     **/
    virtual std::string getDeviceName() const = 0;
    
protected:

    /**
     * Add an input event to the event queue. Called internally by the
     * input device whenever it needs to send a newly registered input
     * event to the platform (and to the event manager).
     *
     * @param event input event to add to the event queue.
     **/
    void addInputEvent(const InputEvent &event) {
	_eventQueue->push(event);
    }

private:
    InputEventQueue *_eventQueue;
};

#endif /* InputDevice.hh */
