/* ------------------------------------------------------------------------
 * $Id: SDLfbconPlatform.hh,v 1.3 2001/07/18 07:47:49 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-05-05 by Steve Houston.
 *
 * Copyright (c) 2000 Antony Suter <antony@mira.net>.
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2001 Steve Houston <shouston@progammer.net>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _SDLfbconPlatform_hh_
#define _SDLfbconPlatform_hh_

// -- System Includes
extern "C" {
#include <SDL/SDL.h>
#include <GL/osmesa.h>
}

// -- 3Dwm Includes
#include "Polhem/Platform.hh"

// -- Forward Declarations
class Thread;

// -- Class Declarations

/**
 * SDL FbCon Platform implementation class.
 **/
class SDLfbconPlatform {
    
public:

    /**
     * Constructor.
     **/
    SDLfbconPlatform(int &argc, char **argv, int w, int h, int d);

    /**
     * Destructor.
     **/
    ~SDLfbconPlatform();

    /** 
     * 
     **/
    RendererImpl *createRenderer();

    /**
     * Retrieve the next input event from the platform subsystem.
     * Will block on this call until an event is received.
     *
     * @return the next input event. 
     **/
    InputEvent getNextInputEvent();

    void clearDisplay();
    void swapDisplay();

    int getDisplayWidth() const { return _width; }
    int getDisplayHeight() const { return _height; }
    int getDisplayDepth() const { return _depth; }

    void addInputDevice(InputDevice *device);
    
private:
    
    SDL_Surface *_onScreen;
    SDL_Surface *_offScreen;
    OSMesaContext _mesaContext;
    int _width, _height, _depth;
    InputEventQueue _eventQueue;
    std::vector<InputDevice *> _devices;
    std::vector<Thread *> _deviceThreads;
};

#endif /* SDLfbconPlatform.hh */
