/* ------------------------------------------------------------------------
 * $Id: NodeKitImpl.cc,v 1.5 2001/08/21 21:37:40 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-10-24 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- 3Dwm Includes
#include "Celsius/Mutex.hh"
#include "Polhem/NodeImpl.hh"
#include "Polhem/ShapeImpl.hh"
#include "Polhem/Group.hh"
#include "Polhem/VNCDesktop.hh"
#include "Polhem/NodeKitImpl.hh"

using namespace Nobel;

// -- Code Segment

Shape_ptr NodeKitImpl::createShape()
{
    ShapeImpl *node = activate(new ShapeImpl());
    return node->_this();
}

Node_ptr NodeKitImpl::createGroup()
{
    Group *node = activate(new Group());
    return node->_this();
}

Desktop_ptr NodeKitImpl::createVNCDesktop(const char* host,
					  CORBA::Short port,
					  const char* passwd)
{
    VNCDesktop *desktop = activate(new VNCDesktop(host, port, passwd));
    return desktop->_this();
}
