// $Id: xxl_round.cc,v 1.5 1997/01/07 00:48:40 aml Exp $

#include "xxl_funcs.hh"
#include "sheet.hh"


static int mult[10] = {1,10,100,1000,10000,100000,1000000,10000000,100000000,1000000000};

Stack_elem *Round::eval(Stack_elem *p,Sheet *sheet, short col, short row) {
    double x;
    int digits;

    x = sheet->stack_value(p-1);
    digits = (int) sheet->stack_value(p);

    if (!sheet->propagate_error(p-1,se) ) {
        if (digits > 9 || digits < 0) 
            SET_ERROR(se,ERROR_BAD_VALUE)
        else {
            x = x*mult[digits];
            x = floor(x+0.5);
            x = x/mult[digits];
        }
    }
    se->type = FORM_FP;
    se->contents.fp_val = x;
    return(se);
}

Round::Round() {
    se = new Stack_elem;
}

Round::~Round() {
    delete se;
}

// $Log: xxl_round.cc,v $
// Revision 1.5  1997/01/07  00:48:40  aml
// Error propagation.
//
// Revision 1.4  1997/01/02  16:15:32  aml
// Fixed unsufficient range of colunm width.
// First cut of vlookup and hlookup functions.
// Fixed bug in display routines.
//
// Revision 1.3  1996/12/11 21:39:50  aml
// Sumif implemented.
// Diverse time functions implemented.
// Fixed needtoscroll2 to avoid out of control scroll.
//
// Revision 1.2  1996/08/26 17:22:25  aml
// Function Round fixed.
// Many other functions added, from power to mod.
//
// Revision 1.1  1996/03/08 12:48:30  aml
// Initial revision
//
