
/* 
	--- ACA example ---
	
	Show:
		Standard widget table definition and session operation.		
 */

#include <aca/aca.h>
#include <aca/aca_widget.h>

#include "examples_colors.h"

   void spec_resize(void *data)
   {
   	W_redraw_session((SessW *) data);
   	clean_hline(LINES-2, 0, COLS, WHITE_RED);
   }

   void bgr_examp(SessW *s)
   {
      clean_box(0, 0, LINES, COLS, WHITE_BLUE); 
      center_addnstr(5, COLS/2, "ACA button example\n{ QUIT: press button quit or key F10 }", 40);		
      mvaddstr(LINES-1, COLS-17,"(C) Zakkr - 1999");
   }

   int main() 
   {
      /*
       * Own button
       */
      Wbutton but = { "[ |H|ello ]", 0,0 };
      
      /*
       * Set widgets -- 3 ACA built-in buttons (locales sensitive) and one 
       * above defined button "hello" (for this button for locale sensitive 
       * you must create mesg. catalog for this program)
       * 
       */
      Widget	w[] = {
      	{ TRUE, 10,9,0,0, button_fn, (void *) &def_button[_BUTT_OK],     Wf_DEFAULT, ACA_TD },
      	{ TRUE, 12,9,0,0, button_fn, (void *) &def_button[_BUTT_CANCEL], Wf_DEFAULT, ACA_TD },
        { TRUE, 14,9,0,0, button_fn, (void *) &but, Wf_DEFAULT, NULL },
      	{ TRUE, 16,9,0,0, button_fn, (void *) &def_button[_BUTT_QUIT], Wf_DEFAULT, ACA_TD },
      	W_NULL 
      };
      SessW	s;

      setlocale(LC_MESSAGES, "");
   
      init_aca(TRUE);
      init_keys((aca_INI *) NULL);
      aca.extra_resize		= TRUE;
      aca.extra_resize_call_fn 	= spec_resize;
      aca.extra_resize_data	= (void *) &s;

      examples_colors(); 
      init_sessw(&s, 0, FALSE, w, bgr_examp, Sf_DEFAULT);
   
      W_redraw_session(&s);
      do {
         if (s.key == K_SCREEN_RESIZED) continue;
         clean_hline(LINES-2, 0, COLS, WHITE_RED);     
         if (run_act_widget(&s) & Wr_BUTTON_PRESS) {
            if (s.actual == 0)	
               center_addnstr(LINES-2, COLS/2, "PRESS: 'OK'.", 12);
            else if (s.actual == 1)	
               center_addnstr(LINES-2, COLS/2, "PRESS: 'CANCEL'.", 15);
            else 			
               exit(RE_OK);							
         }
         W_key_to_widgets(&s);		
         W_default_go(&s);
      } while((s.key = get_k()) != KEY_F(10));  
   
      exit(RE_OK);							
   }
