
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: aca_widget.h,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */

#ifndef __ACA_WIDGET_H
#define __ACA_WIDGET_H

   typedef struct Widget {
      int		hotkey;
      int		y, x;		
      int		lines, cols;		
      int		(*widget_fn)();		/* widget function */
      void		*widget_data;		/* pointer to Wbutton or Wmenu ...etc */
      int		flag;
      char		*text_domain;		/* locale text domain used for this widget, (usually NULL) */
      int		id;			/* Widget ID */
   } Widget;

/*
 * Locales NOTE:
 *	ACA support mix differend locales message catalogs in one widget 
 *	session. For this is must be set correct Widget.text_domain option
 *	-- if you use complete built-in widgets (like buttons "OK") use as
 *	Widget.text_domain = ACA_TD (it's macro no string), if you use your
 *	texts set Widget.text_domain = NULL. 
 */

#define run_act_widget(s) ((*((s)->wtab+(s)->actual)).widget_fn((s),(s)->wtab+(s)->actual, \
			   (*((s)->wtab+(s)->actual)).widget_data, (s)->key, WIDGET_KEY)) 

#define draw_act_widget(s) ((*((s)->wtab+(s)->actual)).widget_fn((s),(s)->wtab+(s)->actual, \
			    (*((s)->wtab+(s)->actual)).widget_data, K_STAY, WIDGET_DRAW)) 			        

#define run_widget(s, num, key) ((*((s)->wtab+num)).widget_fn((s),(s)->wtab+num, \
			   (*((s)->wtab+num)).widget_data, (key), WIDGET_KEY))

#define draw_widget(s, num) ((*((s)->wtab+num)).widget_fn((s),(s)->wtab+num, \
			     (*((s)->wtab+num)).widget_data, K_STAY, WIDGET_DRAW))		

#define	W_NULL	{ FALSE,0,0,0,0, NULL, (void *) NULL, 0, NULL, 0 }   

/* widget flag: */
#define	Wf_DEFAULT	0		
#define	Wf_NOTVISIBLE	0x01		
#define Wf_NOTUSE_ASTR	0x02

typedef enum {
   WIDGET_DRAW,
   WIDGET_KEY
} Msg;

/* widget_fn return: */
#define Wr_NEED_REDRAW	0x01
#define	Wr_ERROR	0x02
#define	Wr_OK		0x04
#define	Wr_BUTTON_PRESS	0x08
#define	Wr_RADIO_SET	0x10
#define	Wr_RADIO_UNSET	0x20
#define	Wr_RADIO_DEPEND	0x40
#define	Wr_INPUT_CHANGE	0x80
#define	Wr_MENU_CHANGE	0x100
#define	Wr_MENU_PRESS	0x200
#define Wr_MENU_OUT	0x400 

   extern int get_astr_size(Widget *w);
   extern int set_widgets_progression(int first_x, char *format, ...);
   extern int size_widgets_progression(char *format, ...);

/* Widgets Session */
   typedef struct SessW {
      int	count,			/* num. of widgets in session */
      		actual,			/* num. of actual widget */
      		lock;			/* can't switch to other widget */
      Widget	*wtab;			/* Widgets table */
      int	key;			/* througt into widgets session */
      
      void	(*bgr_redraw)(struct SessW *s);
      int	flag;
      
      /* not implement now (!) */ 	
      struct SessW	*next,			
      			*prev;
   } SessW;

#define Sf_DEFAULT	0		/* Default session */
#define Sf_NOT_BGR	0x01		/* Session not has background func. */  

/* Locks: */
#define UN_LOCK		FALSE		/* Session is not locked */
#define SOFT_LOCK	TRUE		/* Session is locked, but has widget
					   hotkey reaction */ 
#define HOTKEY_LOCK	2		/* Session is total locked, unlock
					   allowed for active widget only,
					   or if is called set_widget() */

   extern void init_sessw(SessW *s, int actual, int lock, Widget *wtab, 
   			void (*bgr_redraw)(), int flag);

   extern void	set_widget(Widget *wtab, SessW *s, int new_actual);
   extern int	W_go_down(SessW *s);
   extern int	W_go_up(SessW *s);
   extern void	W_redraw_session(SessW *s);
   extern int	W_key_to_widgets(SessW *s);
   extern void	W_default_go(SessW *s);

/* ---- button ---- */
   typedef struct {
      char		*astr;		/* button text */
      int		astr_size;	/* size of button label */
      int		flag;		/* button option */
   } Wbutton;

/* flag */
#define Wb_PRESS_GO	0x01		
/* if press (mouse or hotkey) - button not set active only, 
   but even return Wr_BUTTOTN_PRESS, button color is 'sel' (still) 
   (not change color sel/nsel) 
 */ 


   extern int button_fn(SessW *s, Widget *w, void *data, int key, int Msg);

/* --- radio --- */
   typedef struct {
      char		*astr;		/* radio text (title) */
      int		astr_size;	/* size of radio text */	
      int		set,		/* TRUE / FALSE */		
      *point,
      flag,
      mybit;		/* if B_DEPEND - num. of bit in point,
   				(if radio is set mybit in 'point' is 1 and other 
   				bit (for other radio butt.) are unset=0) */
   } Wradio;

/* flag: */
/* more radio buttons are have dependence of one (int) 'point'.  
	- each radio button have one bit in 'point' */
#define B_DEPEND	0x01		

   extern int radio_fn(SessW *s, Widget *w, void *data, int key, int Msg);


/* --- input --- */
   typedef struct {
      char		*astr;		/* input title */
      int		astr_size;	/* size of input title */	
      char		*str;
      int		poz,
      a_size,
      flag,		/* Wi_TOP */		
      max;
   } Winput;

/* flag: */
#define	Wi_TOP		0x01		/* title is over input area */ 

   extern int input_fn(SessW *s, Widget *w, void *data, int key, int Msg);
/* => if this widget active - widgets session is lock,
	unlock it only if press Up/Down or (if set) some hotkey */


/* --- menu --- */
   typedef struct Wmenu { 
      char 		*astr;		/* menu title (if flg is M_TITLE) */
      int		astr_size,	/* size of menu title 	*/
      			flag,		/* used: M_TITLE | M_OPEN ..etc. */ 
      			item_max,	/* max. of item in menu */
      			item_act,	/* actual item in menu  */
      			item_last,	/* prev. actual item    */
      			scr_max,	/* max. line of menu	*/
      			scr_act,	/* actual line 		*/
      			scr_last,	/* prev. line		*/
      			sht_act,	/* actual shift		*/
      			sht_max,	/* max menu shift	*/		
      			fios,		/* first item of screen */
      			lios;		/* last  item of screen */
      char		**alist;	/* menu strings (if flag is M_ALIST) */
      void		*list;		/* menu list for your line_printer 
      					   (if you want it) */
      /* menu printer func. (print one line only) */ 
      void		(*line_printer)(struct Wmenu *m, Widget *w, int line, int cols, int item);
      
      /* menu descript printer func. (print first line (if M_DESCRIPT flag is set)) */ 
      void		(*descript_printer)(struct Wmenu *m, Widget *w, int line, int cols);	

      char		*descript;	/* description string */
   } Wmenu;

#define alistN	((char **) NULL)

/* flags: */
#define	M_TITLE		0x01		/* menu has title */
#define	M_TOPTITLE	0x02		/* menu has top title */
#define M_OPEN		0x04 		/* menu for ever open */
#define M_BORDER	0x08		/* menu with border */
#define M_ALIST		0x10		/* menu used ACTIVE_STR *alist */
#define M_NOTOUT	0x20		/* if press '\n' not go to next widget */
#define M_STILLV	0x40		/* menu curstor still visible */
#define M_DESCRIPT	0x80		/* first line is description line - not roll this line */ 
#define M_SHTMENU	0x100		/* shifted menu  (roll to LEFT || RIGHT) */
#define M_EDIT		0x4000		/* switch for edit mode */
/* flags for color */
#define M_COLORIN	0x200		/* menu in any dialog (example: in Dlg_SelectFile() ) */
#define M_COLOROUT	0x400		/* out of all dialogs (example: top menu of (program) Kim */
#define M_COLORDIRECT	0x800 		/* (example: big blue area of (program) Kim */
#define M_TITLE_NSEL	0x1000		/* Title color = title_nsel (still) */

#define M_SLIST		0x2000		/* Standard string list on **alist 
					   in struct Wmenu */

#define ACA_RESET_MENU(m){			\
      		m->item_act	= 0;		\
      		m->item_last	= 0;		\
      		m->scr_act	= 0;		\
		m->scr_last	= 0;		\
		m->fios		= 0;		\
		m->sht_act	= 0;		\
}

/* flags : */
#define	DUMMY_GO	0x01	/* increment all item in ACA_MENU, but not
				   write (rewrite) it in screen */   

   extern void	menu_dummy_go(Widget *w, Wmenu *m, int key, int num);

#define set_color_menu_in(m, l) {		\
	if (m->scr_act == l) {			\
		ubold;				\
		aca_c(TplC->menu_in.sel);	\
	}					\
	else {					\
		ubold;				\
		aca_c(TplC->menu_in.nsel);	\
	}					\
}
#define set_color_menu_out(m, l) {		\
	if (m->scr_act == l) {			\
		ubold;				\
		aca_c(TplC->menu_out.sel);	\
	}					\
	else {					\
		ubold;				\
		aca_c(TplC->menu_out.nsel);	\
	}					\
}
#define set_color_menu_direct(m, l) {		\
	if (m->scr_act == l) {			\
		ubold;				\
		aca_c(TplC->menu_direct.sel);	\
	}					\
	else {					\
		ubold;				\
		aca_c(TplC->menu_direct.nsel);	\
	}					\
}


/* print astr item in menu alist*/
   extern void 	mpr_astr(Wmenu *m, Widget *w, int line, int cols, int item); 

/* print str item in menu alist*/
   extern void 	mpr_str(Wmenu *m, Widget *w, int line, int cols, int item); 

/* print description string (if M_DESCRIPT is set) */
   extern void mpr_descript (Wmenu *m, Widget *w, int line, int cols); 

   extern void	menu_seek(Wmenu *m, Widget *w, int k, int flag); 
   extern int 	menu_fn(SessW *s, Widget *w, void *data, int key, int Msg);
   extern int 	is_mouse_in_widget(Widget *w, SessW *s);

   extern void	clean_menu(Wmenu *m, Widget *w);

   extern void	decrease_item(Wmenu *m); 

   extern void init_view(Wmenu *view_m);	
   extern void mpr_view (Wmenu *m, Widget *w, int line, int cols, int item);

/* edit data - use instead *list in Wmenu if you use M_EDIT flag */
   typedef struct {
      char	*str;		/* edited string	*/
      int	bufsiz;		/* max. lenght of the *str buffer */	
      char	*line_act;	/* actual line */	
      int	line_act_len;	/* length of the actual line */	
      int	c_poz;		/* cursor cols pozition	*/
      int	a_size;		/* current *str length */
   } Edata;

   extern void init_edit(Wmenu *edit_m, Edata *edata);	
   extern void mpr_edit (Wmenu *m, Widget *w, int line, int cols, int item);
   extern int  input_to_line(Wmenu *m, Edata *e, Widget *w, int key);


/* ------------ predefined widgets -------------- */

   extern Wbutton def_button[]; 

   typedef enum {
   	_BUTT_QUIT,
   	_BUTT_OK,
   	_BUTT_CANCEL,
   	_BUTT_SAVE,
   	_BUTT_NEW
   } _aca_buttons;


#endif /* __ACA_WIDGET_H */
