// be_string.cpp,v 1.32 2003/10/28 18:30:37 bala Exp

// ============================================================================
//
// = LIBRARY
//    TAO IDL
//
// = FILENAME
//    be_string.cpp
//
// = DESCRIPTION
//    Extension of class AST_String that provides additional means for C++
//    mapping.
//
// = AUTHOR
//    Copyright 1994-1995 by Sun Microsystems, Inc.
//    and
//    Aniruddha Gokhale
//
// ============================================================================

#include "be_string.h"
#include "be_visitor.h"

#include "utl_identifier.h"
#include "global_extern.h"

ACE_RCSID (be, 
           be_string, 
           "be_string.cpp,v 1.32 2003/10/28 18:30:37 bala Exp")

be_string::be_string (void)
  : COMMON_Base (),
    AST_Decl (),
    AST_Type (),
    AST_String (),
    be_decl (),
    be_type ()
{
  // Always the case.
  this->size_type (AST_Type::VARIABLE);
}

be_string::be_string (AST_Decl::NodeType nt,
                      UTL_ScopedName *n,
                      AST_Expression *v,
                      long width)
  : COMMON_Base (),
    AST_Decl (nt,
              n,
              I_TRUE),
    AST_Type (nt,
              n),
    AST_String (nt,
                n,
                v,
                width),
    be_decl (nt,
             n),
    be_type (nt,
             n)
{
  ACE_SET_BITS (idl_global->decls_seen_info_,
                idl_global->decls_seen_masks.string_seen_);
}

// Overriden method.
void
be_string::compute_tc_name (void)
{
  // Start with the head as the CORBA namespace.
  Identifier *corba_id = 0;
  ACE_NEW (corba_id,
           Identifier ("CORBA"));

  ACE_NEW (this->tc_name_,
           UTL_ScopedName (corba_id,
                           0));

  Identifier *id = 0;
  ACE_NEW (id,
           Identifier ("_tc_string"));

  UTL_ScopedName *conc_name = 0;
  ACE_NEW (conc_name,
           UTL_ScopedName (id,
                           0));

  this->tc_name_->nconc (conc_name);
}

int
be_string::accept (be_visitor *visitor)
{
  return visitor->visit_string (this);
}

void
be_string::destroy (void)
{
  this->be_type::destroy ();
  this->AST_String::destroy ();
}

// Narrowing.
IMPL_NARROW_METHODS2 (be_string, AST_String, be_type)
IMPL_NARROW_FROM_DECL (be_string)
