//==============================================================
/**
 *  @file  DP_PCD_Handler.h
 *
 *  DP_PCD_Handler.h,v 1.3 2005/03/19 22:22:21 jai Exp
 *
 *  Handler for Deployment::PlanConnectionHandler
 *
 *  @author Jules White <jules@dre.vanderbilt.edu>
 */
//================================================================

#ifndef CIAO_CONFIG_HANDLERS_DP_PCD_HANDLER_H
#define CIAO_CONFIG_HANDLERS_DP_PCD_HANDLER_H
#include /**/ "ace/pre.h"

#include "Config_Handlers/Config_Handlers_Export.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

namespace Deployment
{
  struct PlanConnectionDescription;
  class PlanConnectionDescriptions;
}

namespace CIAO
{

  namespace Config_Handlers
  {
    class DeploymentPlan;
    class PlanConnectionDescription;

   /*
    * @class DP_PCD_Handler
    *
    * @brief Handler class for <PlanConnectionDescription> types.
    *
    * This class defines handler methods to map values from
    * XSC PlanConnectionDescription objects, parsed from
    * the descriptor files, to the corresponding CORBA IDL type.
    *
    */

    class Config_Handlers_Export DP_PCD_Handler
    {
    public:
      static bool plan_connection_descrs (
          const DeploymentPlan &src,
          Deployment::PlanConnectionDescriptions& toconfig);

    private:
      static bool plan_connection_descr (
          const PlanConnectionDescription& desc,
          Deployment::PlanConnectionDescription& toconfig);
    };
  }
}

#include /**/ "ace/post.h"
#endif /* CIAO_CONFIG_HANDLERS_PCD_HANDLER_H*/
