// -*- C++ -*-
//=============================================================================
/**
 *  @file   PushConsumer.h
 *
 *  PushConsumer.h,v 1.6 2004/08/16 23:53:16 jtc Exp
 *
 *  @author Huang-Ming Huang <hh1@cse.wustl.edu>
 */
//=============================================================================

#ifndef PUSHCONSUMERIMPL_H
#define PUSHCONSUMERIMPL_H

#include "orbsvcs/RtecEventCommS.h"

class PushConsumer_impl :
public virtual POA_RtecEventComm::PushConsumer
{
public:
  PushConsumer_impl(CORBA::ORB_ptr orb);

    virtual void push (
        const RtecEventComm::EventSet & data
        ACE_ENV_ARG_DECL
      )
      ACE_THROW_SPEC ((
        CORBA::SystemException
      ));

    virtual void disconnect_push_consumer (
        ACE_ENV_SINGLE_ARG_DECL
      )
      ACE_THROW_SPEC ((
        CORBA::SystemException
      ));
private:
  CORBA::ORB_var orb_;
  PushConsumer_impl(const PushConsumer_impl&);
  bool operator==(const PushConsumer_impl&);
};
#endif
