package VC10WorkspaceCreator;

# ************************************************************
# Description   : A VC10 Workspace Creator
# Author        : Johnny Willemsen
# Create Date   : 11/10/2008
# ************************************************************

# ************************************************************
# Pragmas
# ************************************************************

use strict;

use VC10ProjectCreator;
use VC9WorkspaceCreator;

use vars qw(@ISA);
@ISA = qw(VC9WorkspaceCreator);

# ************************************************************
# Subroutine Section
# ************************************************************

sub pre_workspace {
  my($self, $fh) = @_;
  my $crlf = $self->crlf();

  print $fh '﻿', $crlf,
            'Microsoft Visual Studio Solution File, Format Version 11.00', $crlf;
  $self->print_workspace_comment($fh,
            '# Visual Studio 10', $crlf,
            '# $Id: VC10WorkspaceCreator.pm 1577 2009-05-07 15:44:53Z elliott_c $', $crlf,
            '#', $crlf,
            '# This file was generated by MPC.  Any changes made directly to', $crlf,
            '# this file will be lost the next time it is generated.', $crlf,
            '#', $crlf,
            '# MPC Command:', $crlf,
            '# ', $self->create_command_line_string($0, @ARGV), $crlf);
}

1;
