/***********************************************************
/       Title: usbserial_linux.c
/       Author: David Corcoran
/      Purpose: Abstracts usb API to serial like calls
************************************************************/

#include <stdio.h>
#include <pcscdefines.h>
#include <usbserial_linux.h>
#include <stdlib.h>
#include <usblinux.h>
#include "config.h"

#define USBWRITE_PIPE   0x81
#define USBREAD_PIPE    0x81
#define USBMAX_READERS  4

/* Change the following to uniquely match your reader. */
enum {
    kMyVendorID			= 0x072F,   /* change to match your reader */
    kMyProductID		= 0x9000,   /* change to match your reader */
};

static int usbDevice = 0;
static int fd_list[USBMAX_READERS] = {0,0,0,0};
 
#define USB_TYPE_STANDARD               (0x00 << 5)
#define USB_TYPE_CLASS                  (0x01 << 5)
#define USB_TYPE_VENDOR                 (0x02 << 5)
#define USB_TYPE_RESERVED               (0x03 << 5)
 
#define USB_RECIP_DEVICE                0x00
#define USB_RECIP_INTERFACE             0x01
#define USB_RECIP_ENDPOINT              0x02
#define USB_RECIP_OTHER                 0x03
 
#define USB_DIR_OUT                     0
#define USB_DIR_IN                      0x80

RESPONSECODE OpenUSB( DWORD lun )
{
	usbDevice = open_linux_usb_dev( kMyVendorID, kMyProductID, lun );
	
	if ( usbDevice <= 0 ) {
		return STATUS_UNSUCCESSFUL;
	}
	
	fd_list[lun] = usbDevice;
	return STATUS_SUCCESS;  
}

RESPONSECODE WriteUSB( DWORD lun, DWORD length, unsigned char *buffer )
{

	int rv, len;

#ifdef USBDEBUG
	int i;
	printf("-> [%d] ", (int)length);
	for (i=0; i < length; i++ )
	{
		printf("%x ", buffer[i]);
	}
	printf("\n");
#endif  

	len = length;
	
	rv = bulk_linux_usb_dev( fd_list[lun], 0x02, buffer,
							&len, 50000 );
	if ( rv < 0 ) {
		return STATUS_UNSUCCESSFUL;
	}
	
	return STATUS_SUCCESS;

}

RESPONSECODE ReadUSB( DWORD lun, DWORD *length, unsigned char *buffer )
{

	int rv, len;
	int fd = 0;
#ifdef USBDEBUG
	int i;
#endif

	len = *length;
	
	rv = bulk_linux_usb_dev( fd_list[lun], 0x82, buffer,
							&len, 50000 );
	
	*length = len;
	
	if ( rv < 0 )
	{
		return STATUS_UNSUCCESSFUL;
	}
	
#ifdef USBDEBUG
	printf("<- [%d] ", len);
	for (i=0; i < len; i++ )
	{
		printf("%x ", buffer[i]);
	}
	printf("\n");
#endif  

  return STATUS_SUCCESS;
}

RESPONSECODE CloseUSB( DWORD lun )
{
    close_linux_usb_dev( fd_list[lun] );
    return STATUS_SUCCESS;
}
