/*--- error.h ------------------------------------------------------------------
Copyright (C) 2004, 2005 Sylvain Fourmanoit <syfou@users.sourceforge.net>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.   
------------------------------------------------------------------------------*/
/* Wrapper around system error functions    	        		      */

/*----------------------------------------------------------------------------*/
#ifndef HAVE_ERROR_H
#define HAVE_ERROR_H

#ifndef HAVE_CONFIG_H
#error Autogenerated config.h should be used.
#endif

/*----------------------------------------------------------------------------*/
#include "config.h"			/* Autoconf header */

#ifdef HAVE_ERRNO_H
#include <errno.h>			/* C includes */
#endif

/*----------------------------------------------------------------------------*/
extern int errno_bis;

/*----------------------------------------------------------------------------*/
/* Error related management
 */
#define TRY_CATCH(x)\
do {\
  errno=0;\
  do { x; } while(0);\
  if(errno) { errno_bis=errno; return 0;}\
} while(0)

/* Whenever TRY is going to be used in a function,
   TRY_RESET should be invoked before. */
#define TRY(x)\
do {\
   errno=0;\
   do { x; } while(0);\
   if(errno) errno_bis=errno;\
} while(0)

#define TRY_SUCCESS (errno_bis==0)
#define TRY_RESET errno_bis=0

/*----------------------------------------------------------------------------*/
/* Debugging related. 
   I know, I know, variadic macros are ISO99 C, not ANSI... 
 */
#ifdef DEBUG
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif
#ifdef HAVE_STDARG_H
#include <stdarg.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
void debug_init(void);
int debug(const char *, ...);
int vdebug(const char *, va_list);
int debug_on_stderr(void);
#else
#define debug( ... )
#endif

/* Now, make sure we have strerror() defined 
 */
#ifdef HAVE_STRING_H 
#include <string.h>
#else
#ifdef HAVE_ERRNO_H
#define strerror(errnum) sys_errlist[errnum]
#else
#define strerror(errnum) NULL
#endif
#endif

/*----------------------------------------------------------------------------*/
#endif
