# Programming language detection mechanism.
#
# Author::    Yutaka Yanoh <mailto:yanoh@users.sourceforge.net>
# Copyright:: Copyright (C) 2010-2012, OGIS-RI Co.,Ltd.
# License::   GPLv3+: GNU General Public License version 3 or later
#
# Owner::     Yutaka Yanoh <mailto:yanoh@users.sourceforge.net>

#--
#     ___    ____  __    ___   _________
#    /   |  / _  |/ /   / / | / /__  __/           Source Code Static Analyzer
#   / /| | / / / / /   / /  |/ /  / /                   AdLint - Advanced Lint
#  / __  |/ /_/ / /___/ / /|  /  / /
# /_/  |_|_____/_____/_/_/ |_/  /_/   Copyright (C) 2010-2012, OGIS-RI Co.,Ltd.
#
# This file is part of AdLint.
#
# AdLint is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# AdLint is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# AdLint.  If not, see <http://www.gnu.org/licenses/>.
#
#++

require "adlint/cpp/scanner"
require "adlint/cpp/phase"
require "adlint/c/scanner"
require "adlint/c/phase"

module AdLint #:nodoc:

  # == DESCRIPTION
  # Programming language.
  class Language
    # === DESCRIPTION
    # Detects programming language of the specified source file.
    #
    # === PARAMETER
    # _fpath_:: Pathname -- File path of the source file.
    #
    # === RETURN VALUE
    # Language -- Object of the derived class of Language class.
    def self.of(fpath)
      # FIXME: Dummy implementation.
      C
    end

    class Cpp
      extend AdLint::Cpp::Scanner

      class << self
        def single_module_phases; [] end
        def check_phases; [] end
      end
    end

    class C
      include AdLint::C::ScannerConstants
      extend AdLint::C::Scanner

      class << self
        def single_module_phases
          [
            AdLint::Cpp::Prepare1Phase,
            AdLint::C::Prepare1Phase,
            AdLint::Cpp::Prepare2Phase,
            AdLint::Cpp::EvalPhase,
            AdLint::Cpp::SubstPhase,
            AdLint::C::ParsePhase,
            AdLint::C::ResolvePhase,
            AdLint::C::Prepare2Phase,
            AdLint::C::InterpPhase,
            AdLint::Cpp::ReviewPhase,
            AdLint::C::ReviewPhase,
            AdLint::Cpp::CommandPhase,
            AdLint::C::CommandPhase
          ].freeze
        end

        def check_phases
          [
            AdLint::Cpp::Prepare1Phase,
            AdLint::Cpp::EvalPhase,
            AdLint::Cpp::SubstPhase,
            AdLint::C::ParsePhase
          ].freeze
        end
      end
    end
  end

end
