/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-07-12 15:24:33 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef _ULDATABASEINDEX_H_
#define _ULDATABASEINDEX_H_

#include <Foundation/Foundation.h>
#include <AdunKernel/AdunModelObject.h>

/**
Index for use with file based database.
\todo Improve method of removing and updating object output references.
*/

@interface ULDatabaseIndex : NSObject
{
	int lastNumber;
	NSMutableDictionary* index;
	NSMutableArray* indexArray; 	//!< An array of the current metadatas
	NSString* databaseDir;
	NSMutableDictionary* objectInputReferences;
	NSMutableDictionary* objectOutputReferences;

}

- (id) initWithDirectory: (NSString*) dir;
- (void) addObject: (id) object;
- (BOOL) objectInIndex: (id) object;
- (void) removeObjectWithId: (id) object;
- (void) removeObjectsWithIds: (NSArray*) idents;
- (id) unarchiveObjectWithId: (NSString*) id;
- (void) updateMetadataForObject: (id) object;
- (void) updateOutputReferencesForObject: (id) object;
- (void) removeOutputReferenceToObjectWithId: (NSString*) identOne 
		fromObjectWithId: (NSString*) identTwo;
- (void) reindexAll;
- (NSArray*) availableObjects;
- (NSDictionary*) metadataForObjectWithID: (NSString*) ident;
- (NSArray*) outputReferencesForObjectWithID: (NSString*) ident;
- (NSArray*) inputReferencesForObjectWithID: (NSString*) ident;

@end


#endif // _ULSIMULATIONDATABASE.M_H_

