/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-06-02 15:34:11 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef _ULMATRIX_H_
#define _ULMATRIX_H_

#include <gsl/gsl_matrix.h>
#include <Foundation/Foundation.h>
#include <AdunKernel/AdunDefinitions.h>
#include <AdunKernel/AdunDataMatrix.h>

/**
ULMatrix has been moved to the AdunKernel library and renamed AdDataMatrix.
However in order to ease the transition we will retain ULMatrix by simply implementing
it as a descendant of AdDataMatrix. In this way we avoid having to change every
occurance of ULMatrix in UserLand (of which there are many) straight away.
However ULMatrix is deprecated and should not be used from now on.
\ingroup model
*/

@interface ULMatrix : AdDataMatrix
/**
Returns the number of rows.
Deprecated - use numberOfRows instead.
*/
- (int) Rows;

/**
Returns the number of columns
Deprecated - use numberOfColumns instead.
*/
- (int) Columns;
@end

#endif // _ULMATRIX_H_

