//
//	aegis - project change supervisor
//	Copyright (C) 1997, 2002-2005 Peter Miller;
//	All rights reserved.
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
//
// MANIFEST: functions to manipulate basename tree nodes
//

#include <common/ac/stdio.h>
#include <common/ac/string.h>

#include <libaegis/aer/value/string.h>
#include <aefind/function/basename.h>
#include <aefind/function/needs.h>
#include <common/str.h>
#include <aefind/tree/list.h>
#include <aefind/tree/monadic.h>


static rpt_value_ty *
evaluate(tree_ty *tp, string_ty *path1, string_ty *path2, string_ty *path3,
    struct stat *st)
{
    tree_monadic_ty *this_thing;
    rpt_value_ty    *vp;
    rpt_value_ty    *svp;
    rpt_value_ty    *result;
    string_ty	    *s;
    char	    *cp;

    this_thing = (tree_monadic_ty *)tp;
    vp = tree_evaluate(this_thing->arg, path1, path2, path3, st);
    svp = rpt_value_stringize(vp);
    rpt_value_free(vp);

    s = rpt_value_string_query(svp);
    cp = strrchr(s->str_text, '/');
    if (cp)
	++cp;
    else
	cp = s->str_text;
    s = str_from_c(cp);
    rpt_value_free(svp);

    result = rpt_value_string(s);
    str_free(s);
    return result;
}


static tree_method_ty method =
{
    sizeof(tree_monadic_ty),
    "basename",
    tree_monadic_destructor,
    tree_monadic_print,
    evaluate,
    tree_monadic_useful,
    tree_monadic_constant,
    tree_monadic_optimize,
};


tree_ty *
function_basename(tree_list_ty *args)
{
    function_needs_one("basename", args);
    return tree_monadic_new(&method, args->item[0]);
}
