//
//	aegis - project change supervisor
//	Copyright (C) 2004, 2005 Peter Miller;
//	All rights reserved.
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
//
// MANIFEST: interface of the undo_item_unlink_errok class
//

#ifndef LIBAEGIS_UNDO_ITEM_UNLINK_ERROK_H
#define LIBAEGIS_UNDO_ITEM_UNLINK_ERROK_H

#include <common/nstring.h>
#include <libaegis/undo/item.h>

/**
  * The undo_item_unlink_errok class is used to represent an unlink to
  * be performed in the event of an error.  Errors are ignored.
  */
class undo_item_unlink_errok:
    public undo_item
{
public:
    /**
      * The destructor.
      */
    virtual ~undo_item_unlink_errok();

    /**
      * The constructor.
      */
    undo_item_unlink_errok(const nstring &path);

    // See base class for documentation.
    void action();

    // See base class for documentation.
    void unfinished();

private:
    nstring path;

    /**
      * The default constructor.  Do not use.
      */
    undo_item_unlink_errok();

    /**
      * The copy constructor.  Do not use.
      */
    undo_item_unlink_errok(const undo_item_unlink_errok &);

    /**
      * The assignment operator.  Do not use.
      */
    undo_item_unlink_errok &operator=(const undo_item_unlink_errok &);
};

#endif // LIBAEGIS_UNDO_ITEM_UNLINK_ERROK_H
