/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <ccenterbase.h>
#include <ccenter.h>
#include <pixlibrary.h>
#include <qlabel.h>
#include <qvaluelist.h>
#include <qwidgetstack.h>
#include <etab.h>
#include <ecollection.h>
#include <ebutton.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <kconfig.h>
#include <kiconloader.h>

#include <notesconfig.h>
#include <htmlconfig.h>

#include <accountsconfig.h>
#include <composerconfig.h>
#include <groupsconfig.h>
#include <addressbookconfig.h>
#include <contactsconfig.h>
#include <srconfig.h>
#include <mailconfig.h>

extern KConfig *GlobalConfig;

/*
 *		This is a MODAL dialog!
 */

ControlCenter::ControlCenter(QWidget *parent, const char *name) :
	ControlCenterBase(parent, name, true)
{
	initTab();
	initStack();
	okButton->setEnabled(false);
	applyButton->setEnabled(false);
}

void ControlCenter::initTab()
{
	ECollection *ec;
	ec=new ECollection(this);
	// ec->setPersistence(true);
	EButton *b;
	/************************** Address Book ***************************/
	// Contacts
	b=new EButton(BarIcon("ccenter-contacts"), ec);
	b->setText("Contacts");
	connect(b, SIGNAL(clicked()), this, SLOT(contactsFrameRaise()));
	ec->addButton(b);
	
	//Groups
	b=new EButton(BarIcon("ccenter-groups"), ec);
	b->setText("Groups");
	connect(b, SIGNAL(clicked()), this, SLOT(groupsFrameRaise()));
	ec->addButton(b);
	
	//ab options
	b=new EButton(BarIcon("ccenter-other.png"), ec);
	b->setText("Other");
	connect(b, SIGNAL(clicked()), this, SLOT(otherOptFrameRaise()));
	ec->addButton(b);
	tab->addTab(ec,"Address book", BarIcon("ccenter-tab-addressbook"),
		    BarIcon("ccenter-tab-addressbook"));

	/************************** Mail ***************************/
	ec=new ECollection(this);
	// ec->setPersistence(true);
	// Accounts manager
	b=new EButton(BarIcon("ccenter-accounts"), ec);
	b->setText("Accounts");
	connect(b, SIGNAL(clicked()), this, SLOT(accountsFrameRaise()));
	ec->addButton(b);
	
	// send/receive
	b=new EButton(BarIcon("ccenter-sendreceive"), ec);
	b->setText("Send/Receive");
	connect(b, SIGNAL(clicked()), this, SLOT(srOptFrameRaise()));
	ec->addButton(b);
	
	// composer
	b=new EButton(BarIcon("ccenter-composer"), ec);
	b->setText("Composer");
	connect(b, SIGNAL(clicked()), this, SLOT(composerFrameRaise()));
	ec->addButton(b);
	tab->addTab(ec,"Mail", BarIcon("ccenter-tab-mail"),
		    BarIcon("ccenter-tab-mail"));

	/************************** View ***************************/
	ec=new ECollection(this);
	// ec->setPersistence(true);
	// mail formatting
	b=new EButton(BarIcon("ccenter-formatting"), ec);
	b->setText("Formatting");
	connect(b, SIGNAL(clicked()), this, SLOT(formatOptFrameRaise()));
	ec->addButton(b);
	
	// mail view options
	b=new EButton(BarIcon("ccenter-mailview"), ec);
	b->setText("View");
	connect(b, SIGNAL(clicked()), this, SLOT(mailOptFrameRaise()));
	ec->addButton(b);
	tab->addTab(ec,"View", BarIcon("ccenter-tab-view"),
		    BarIcon("ccenter-tab-view"));
	
	/************************** other ***************************/
	ec=new ECollection(this);
	// ec->setPersistence(true);
	// notes
	b=new EButton(BarIcon("ccenter-notes"), ec);
	b->setText("Notes");
	connect(b, SIGNAL(clicked()), this, SLOT(notesFrameRaise()));
	ec->addButton(b);
	
	tab->addTab(ec,"Other", BarIcon("ccenter-tab-other"),
		    BarIcon("ccenter-tab-other"));
}

                      
void ControlCenter::initStack()
{
	// Contacts
	ContactsConfig *contactsConfig=new ContactsConfig(this);
	stack->addWidget(contactsConfig, ContactsConfigID);
	changed.append(false);
	connect(contactsConfig, SIGNAL(changed()), this, SLOT(statusChanged()));
	connect(contactsConfig, SIGNAL(noChanged()), this, SLOT(statusCleared()));
	connect(this, SIGNAL(doSync(bool)), contactsConfig, SLOT(sync(bool)));
	// groups
	GroupsConfig *groupsConfig=new GroupsConfig(this);
	stack->addWidget(groupsConfig, GroupsConfigID);
	changed.append(false);
	connect(groupsConfig, SIGNAL(changed()), this, SLOT(statusChanged()));
	connect(groupsConfig, SIGNAL(noChanged()), this, SLOT(statusCleared()));
	connect(this, SIGNAL(doSync(bool)), groupsConfig, SLOT(sync(bool)));
	// AB
	AddressBookConfig *addressBookConfig=new AddressBookConfig(this);
	stack->addWidget(addressBookConfig, AddressBookConfigID);
	changed.append(false);
	connect(addressBookConfig, SIGNAL(changed()), this, SLOT(statusChanged()));
	connect(addressBookConfig, SIGNAL(noChanged()), this, SLOT(statusCleared()));
	connect(this, SIGNAL(doSync(bool)), addressBookConfig, SLOT(sync(bool)));
	//
	AccountsConfig *accountsConfig=new AccountsConfig(this);
	stack->addWidget(accountsConfig, AccountsConfigID);
	changed.append(false);
	connect(accountsConfig, SIGNAL(changed()), this, SLOT(statusChanged()));
	connect(accountsConfig, SIGNAL(noChanged()), this, SLOT(statusCleared()));
	connect(this, SIGNAL(doSync(bool)), accountsConfig, SLOT(sync(bool)));
	//
	SendReceiveConfig *sendReceiveConfig=new SendReceiveConfig(this);
	stack->addWidget(sendReceiveConfig, SendReceiveConfigID);
	changed.append(false);
	connect(sendReceiveConfig, SIGNAL(changed()), this, SLOT(statusChanged()));
	connect(sendReceiveConfig, SIGNAL(noChanged()), this, SLOT(statusCleared()));
	connect(this, SIGNAL(doSync(bool)), sendReceiveConfig, SLOT(sync(bool)));
	//
	ComposerConfig *composerConfig=new ComposerConfig(this);
	stack->addWidget(composerConfig, ComposerConfigID);
	changed.append(false);
	connect(composerConfig, SIGNAL(changed()), this, SLOT(statusChanged()));
	connect(composerConfig, SIGNAL(noChanged()), this, SLOT(statusCleared()));
	connect(this, SIGNAL(doSync(bool)), composerConfig, SLOT(sync(bool)));
	//
	MailConfig *mailConfig=new MailConfig(this);
	stack->addWidget(mailConfig, MailOptionsConfigID);
	changed.append(false);
	connect(mailConfig, SIGNAL(changed()), this, SLOT(statusChanged()));
	connect(mailConfig, SIGNAL(noChanged()), this, SLOT(statusCleared()));
	connect(this, SIGNAL(doSync(bool)), mailConfig, SLOT(sync(bool)));
	// HTML
	HtmlConfig *htmlConfig= new HtmlConfig(this);
	stack->addWidget(htmlConfig, FormatOptionsConfigID);
	changed.append(false);
	connect(htmlConfig, SIGNAL(changed()), this, SLOT(statusChanged()));
	connect(htmlConfig, SIGNAL(noChanged()), this, SLOT(statusCleared()));
	connect(this, SIGNAL(doSync(bool)), htmlConfig, SLOT(sync(bool)));
	// NOTES
	notesConfig= new NotesConfig(this);
	stack->addWidget(notesConfig, NotesConfigID);
	changed.append(false);
	connect(notesConfig, SIGNAL(changed()), this, SLOT(statusChanged()));
	connect(notesConfig, SIGNAL(noChanged()), this, SLOT(statusCleared()));
	connect(this, SIGNAL(doSync(bool)), notesConfig, SLOT(sync(bool)));
	tab->activateTab(0);
	stack->raiseWidget(0);
}

void ControlCenter::statusChanged()
{
	int idx=stack->id(stack->visibleWidget());
	if(!changed[idx])
	{
		changed[idx]=true;
		applyButton->setEnabled(true);
		okButton->setEnabled(true);
	}
}

void ControlCenter::statusCleared()
{
	int idx=stack->id(stack->visibleWidget());
	if(changed[idx])
	{
		printf(" Staus is cleared for widget %d\n", idx);
		changed[idx]=false;
		applyButton->setEnabled(false);
		if(changed.findIndex(true)==-1)
			okButton->setEnabled(false);
	}
}

void ControlCenter::raise(int widgetNo)
{
	if(changed[widgetNo])
		applyButton->setEnabled(true);
	if(changed.findIndex(true)!=-1)
		okButton->setEnabled(true);
	stack->raiseWidget(widgetNo);
}


void ControlCenter::applyClicked()
{
	emit(doSync(false));
	GlobalConfig->sync();
}

void ControlCenter::cancelClicked()
{
	close();
}

void ControlCenter::eTabActivated(int)
{
}

void ControlCenter::eTabSelected(int, int)
{
}

void ControlCenter::okClicked()
{
	applyClicked();
	if(changed.findIndex(true)!=-1)
	{
		emit(doSync(true));
	}
	GlobalConfig->sync();
	close();
}
/**
 *		Slots for rising up the frames...
 */

void ControlCenter::accountsFrameRaise()
{
	stack->raiseWidget(AccountsConfigID);
	applyButton->setEnabled(changed[AccountsConfigID]);
}

void ControlCenter::composerFrameRaise()
{
	stack->raiseWidget(ComposerConfigID);
	applyButton->setEnabled(changed[ComposerConfigID]);
}

void ControlCenter::contactsFrameRaise()
{
	stack->raiseWidget(ContactsConfigID);
	applyButton->setEnabled(changed[ContactsConfigID]);
}

void ControlCenter::formatOptFrameRaise()
{
	stack->raiseWidget(FormatOptionsConfigID);
	applyButton->setEnabled(changed[FormatOptionsConfigID]);
}

void ControlCenter::groupsFrameRaise()
{
	stack->raiseWidget(GroupsConfigID);
	applyButton->setEnabled(changed[GroupsConfigID]);
}

void ControlCenter::mailOptFrameRaise()
{
	stack->raiseWidget(MailOptionsConfigID);
	applyButton->setEnabled(changed[MailOptionsConfigID]);
}

void ControlCenter::notesFrameRaise()
{
	stack->raiseWidget(NotesConfigID);
	applyButton->setEnabled(changed[NotesConfigID]);
}

void ControlCenter::otherOptFrameRaise()
{
	stack->raiseWidget(AddressBookConfigID);
	applyButton->setEnabled(changed[AddressBookConfigID]);
}

void ControlCenter::srOptFrameRaise()
{
	stack->raiseWidget(SendReceiveConfigID);
	applyButton->setEnabled(changed[SendReceiveConfigID]);
}
