/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qmultilineedit.h>
#include <qgroupbox.h>
#include <qfontdialog.h>
#include <kconfig.h>

#include <composerconfigbase.h>
#include <composerconfig.h>

extern KConfig *GlobalConfig;

ComposerConfig::ComposerConfig(QWidget *parent, const char *name=0) : ComposerConfigBase(parent, name)
{
	load();
}
void ComposerConfig::load()
{
	QString t;

	GlobalConfig->setGroup("Composer");
	_font=GlobalConfig->readFontEntry("Font");
	fontButton->setFont(_font);
	fontButton->setText(_font.family()+ " - " + t.sprintf("%dpt",_font.pointSize()));
	quoteEdit->setText(GlobalConfig->readEntry("QuoteChar"));
	bccCheck->setChecked(GlobalConfig->readEntry("Bcc")=="Yes");
	int editLines=GlobalConfig->readNumEntry("Prefix reply lines");
	for(int i=0;i<editLines;i++)
	{
		t.sprintf("Prefix reply %d",i);
		prefixEdit->insertLine(GlobalConfig->readEntry(t));
	}
}
void ComposerConfig::sync(bool visible=false)
{
	bool doSync=(!visible && isVisible()) | (visible);
	if(!doSync)
		return;
	
	GlobalConfig->setGroup("Composer");
	GlobalConfig->writeEntry("Font", _font);
	GlobalConfig->writeEntry("QuoteChar", quoteEdit->text());
	GlobalConfig->writeEntry("Bcc", ((bccCheck->isChecked())?"Yes":"No"));
	GlobalConfig->writeEntry("Prefix reply lines", prefixEdit->numLines());
	for(int i=0;i<prefixEdit->numLines();i++)
	{
		QString t;
		t.sprintf("Prefix reply %d",i);
		GlobalConfig->writeEntry(t, prefixEdit->textLine(i));
	}
	emit(noChanged());
}
void ComposerConfig::bccClicked()
{
	emit(changed());
}
void ComposerConfig::fontClicked()
{
	bool ok;
	QFont f;
	QString str;
	
	f=QFontDialog::getFont(&ok, _font, this);
	if(ok)
	{
		_font=f;
		fontButton->setFont(_font);
		fontButton->setText(_font.family()+ " - " + str.sprintf("%dpt",_font.pointSize()));
		emit(changed());
	}
}
void ComposerConfig::replyChanged()
{
	emit(changed());
}
void ComposerConfig::quoteChanged(const QString &)
{
	emit(changed());	
}
