#include "editaccountdialogbase.h"

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qslider.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

/*
 *  Constructs a EditAccountDialogBase which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
EditAccountDialogBase::EditAccountDialogBase(QString type, QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    accountType=type;
    if ( !name )
	    setName( "EditAccountDialogBase" );
    resize( 360, 400 );
    setCaption( tr( "Edit Account"  ) );
    QFont f( font() );
    f.setPointSize( 10 );
    setFont( f );
    setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, sizePolicy().hasHeightForWidth() ) );
    setMinimumSize( QSize( 360, 400 ) );
    setMaximumSize( QSize( 360, 400 ) );
    EditAccountDialogBaseLayout = new QGridLayout( this );
    EditAccountDialogBaseLayout->setSpacing( 6 );
    EditAccountDialogBaseLayout->setMargin( 11 );

    cancelButton = new QPushButton( this, "cancelButton" );
    cancelButton->setText( tr( "&Cancel"  ) );

    EditAccountDialogBaseLayout->addWidget( cancelButton, 1, 2 );

    okButton = new QPushButton( this, "okButton" );
    okButton->setText( tr( "&Ok"  ) );

    EditAccountDialogBaseLayout->addWidget( okButton, 1, 1 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    EditAccountDialogBaseLayout->addItem( spacer, 1, 0 );

    TabWidget2 = new QTabWidget( this, "TabWidget2" );
    TabWidget2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, TabWidget2->sizePolicy().hasHeightForWidth() ) );
    TabWidget2->setMinimumSize( QSize( 340, 350 ) );
    TabWidget2->setMaximumSize( QSize( 340, 350 ) );

    tab = new QWidget( TabWidget2, "tab" );
    tabLayout = new QGridLayout( tab );
    tabLayout->setSpacing( 6 );
    tabLayout->setMargin( 11 );

    TextLabel1 = new QLabel( tab, "TextLabel1" );
    TextLabel1->setText( tr( "Account name:"  ) );

    tabLayout->addWidget( TextLabel1, 0, 0 );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    tabLayout->addMultiCell( spacer_2, 2, 2, 3, 5 );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    tabLayout->addMultiCell( spacer_3, 7, 7, 3, 5 );

    TextLabel2 = new QLabel( tab, "TextLabel2" );
    if( accountType=="IMAP4" )
      TextLabel2->setText( tr( "IMAP4 server:"  ) );
    else
      TextLabel2->setText( tr( "POP3 server:"  ) );

    tabLayout->addWidget( TextLabel2, 1, 0 );

    TextLabel3 = new QLabel( tab, "TextLabel3" );
    if( accountType=="IMAP4" )
      TextLabel3->setText( tr( "IMAP4 port:"  ) );
    else
      TextLabel3->setText( tr( "POP3 port:"  ) );

    tabLayout->addWidget( TextLabel3, 2, 0 );

    portEdit = new QLineEdit( tab, "portEdit" );
    portEdit->setMinimumSize( QSize( 45, 0 ) );
    portEdit->setMaximumSize( QSize( 45, 32767 ) );
    portEdit->setText( tr( "110"  ) );

    tabLayout->addWidget( portEdit, 2, 1 );
    QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    tabLayout->addItem( spacer_4, 7, 2 );

    passCheck = new QCheckBox( tab, "passCheck" );
    passCheck->setText( tr( "Remember password"  ) );

    tabLayout->addMultiCellWidget( passCheck, 6, 6, 0, 1 );

    TextLabel5 = new QLabel( tab, "TextLabel5" );
    TextLabel5->setText( tr( "Password:"  ) );

    tabLayout->addWidget( TextLabel5, 5, 0 );

    TextLabel4 = new QLabel( tab, "TextLabel4" );
    TextLabel4->setText( tr( "User name:"  ) );

    tabLayout->addWidget( TextLabel4, 3, 0 );

    TextLabel3_2 = new QLabel( tab, "TextLabel3_2" );
    TextLabel3_2->setText( tr( "User login:"  ) );

    tabLayout->addWidget( TextLabel3_2, 4, 0 );

    serverEdit = new QLineEdit( tab, "popServerEdit" );
    serverEdit->setMinimumSize( QSize( 180, 0 ) );
    serverEdit->setMaximumSize( QSize( 180, 32767 ) );

    tabLayout->addMultiCellWidget( serverEdit, 1, 1, 1, 3 );
    QSpacerItem* spacer_5 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    tabLayout->addMultiCell( spacer_5, 1, 1, 4, 5 );

    accountEdit = new QLineEdit( tab, "accountEdit" );
    accountEdit->setMinimumSize( QSize( 180, 0 ) );
    accountEdit->setMaximumSize( QSize( 180, 32767 ) );

    tabLayout->addMultiCellWidget( accountEdit, 0, 0, 1, 4 );

    loginEdit = new QLineEdit( tab, "loginEdit" );
    loginEdit->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, loginEdit->sizePolicy().hasHeightForWidth() ) );
    loginEdit->setMinimumSize( QSize( 180, 0 ) );
    loginEdit->setMaximumSize( QSize( 180, 32767 ) );

    tabLayout->addMultiCellWidget( loginEdit, 4, 4, 1, 4 );

    userEdit = new QLineEdit( tab, "userEdit" );
    userEdit->setMinimumSize( QSize( 180, 0 ) );
    userEdit->setMaximumSize( QSize( 180, 32767 ) );

    tabLayout->addMultiCellWidget( userEdit, 3, 3, 1, 4 );

    passEdit = new QLineEdit( tab, "passEdit" );
    passEdit->setMinimumSize( QSize( 180, 0 ) );
    passEdit->setMaximumSize( QSize( 180, 32767 ) );
    passEdit->setEnabled( FALSE );
    passEdit->setEchoMode( QLineEdit::Password );

    tabLayout->addMultiCellWidget( passEdit, 5, 5, 1, 4 );
    QSpacerItem* spacer_6 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    tabLayout->addItem( spacer_6, 4, 5 );
    if( accountType=="IMAP4" )
      TabWidget2->insertTab( tab, tr( "IMAP4" ) );
    else
      TabWidget2->insertTab( tab, tr( "POP3" ) );

    tab_2 = new QWidget( TabWidget2, "tab_2" );
    tabLayout_2 = new QGridLayout( tab_2 );
    tabLayout_2->setSpacing( 6 );
    tabLayout_2->setMargin( 11 );

    TextLabel6 = new QLabel( tab_2, "TextLabel6" );
    TextLabel6->setText( tr( "SMTP server:"  ) );

    tabLayout_2->addWidget( TextLabel6, 0, 0 );

    TextLabel8 = new QLabel( tab_2, "TextLabel8" );
    TextLabel8->setText( tr( "From:"  ) );

    tabLayout_2->addWidget( TextLabel8, 2, 0 );

    TextLabel9 = new QLabel( tab_2, "TextLabel9" );
    TextLabel9->setText( tr( "Reply to:"  ) );

    tabLayout_2->addWidget( TextLabel9, 3, 0 );

    smtpServerEdit = new QLineEdit( tab_2, "smtpServerEdit" );
    smtpServerEdit->setMinimumSize( QSize( 180, 0 ) );
    smtpServerEdit->setMaximumSize( QSize( 180, 32767 ) );

    tabLayout_2->addMultiCellWidget( smtpServerEdit, 0, 0, 1, 2 );

    fromEdit = new QLineEdit( tab_2, "fromEdit" );
    fromEdit->setMinimumSize( QSize( 180, 0 ) );
    fromEdit->setMaximumSize( QSize( 180, 32767 ) );

    tabLayout_2->addMultiCellWidget( fromEdit, 2, 2, 1, 2 );

    replyToEdit = new QLineEdit( tab_2, "replyToEdit" );
    replyToEdit->setMinimumSize( QSize( 180, 0 ) );
    replyToEdit->setMaximumSize( QSize( 180, 32767 ) );

    tabLayout_2->addMultiCellWidget( replyToEdit, 3, 3, 1, 2 );

    TextLabel7 = new QLabel( tab_2, "TextLabel7" );
    TextLabel7->setText( tr( "SMTP port:"  ) );

    tabLayout_2->addWidget( TextLabel7, 1, 0 );
    QSpacerItem* spacer_7 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    tabLayout_2->addItem( spacer_7, 4, 2 );
    QSpacerItem* spacer_8 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    tabLayout_2->addItem( spacer_8, 0, 3 );
    QSpacerItem* spacer_9 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    tabLayout_2->addMultiCell( spacer_9, 1, 1, 2, 3 );

    smtpPortEdit = new QLineEdit( tab_2, "smtpPortEdit" );
    smtpPortEdit->setMinimumSize( QSize( 45, 0 ) );
    smtpPortEdit->setMaximumSize( QSize( 45, 32767 ) );
    smtpPortEdit->setText( tr( "25"  ) );

    tabLayout_2->addWidget( smtpPortEdit, 1, 1 );
    TabWidget2->insertTab( tab_2, tr( "SMTP" ) );

    tab_3 = new QWidget( TabWidget2, "tab_3" );
    tabLayout_3 = new QGridLayout( tab_3 );
    tabLayout_3->setSpacing( 6 );
    tabLayout_3->setMargin( 11 );

    GroupBox1 = new QGroupBox( tab_3, "GroupBox1" );
    GroupBox1->setTitle( tr( "Speed:"  ) );
    GroupBox1->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)0, GroupBox1->sizePolicy().hasHeightForWidth() ) );
    GroupBox1->setMinimumSize( QSize( 75, 0 ) );
    GroupBox1->setMaximumSize( QSize( 32767, 75 ) );
    GroupBox1->setColumnLayout(0, Qt::Vertical );
    GroupBox1->layout()->setSpacing( 0 );
    GroupBox1->layout()->setMargin( 0 );
    GroupBox1Layout = new QGridLayout( GroupBox1->layout() );
    GroupBox1Layout->setAlignment( Qt::AlignTop );
    GroupBox1Layout->setSpacing( 6 );
    GroupBox1Layout->setMargin( 11 );

    TextLabel10 = new QLabel( GroupBox1, "TextLabel10" );
    TextLabel10->setText( tr( "Normal"  ) );
    TextLabel10->setMinimumSize( QSize( 45, 0 ) );
    TextLabel10->setMaximumSize( QSize( 45, 32767 ) );

    GroupBox1Layout->addWidget( TextLabel10, 0, 0 );

    speedSlider = new QSlider( GroupBox1, "speedSlider" );
    speedSlider->setOrientation( QSlider::Horizontal );
    speedSlider->setMaxValue( 2 );

    GroupBox1Layout->addMultiCellWidget( speedSlider, 1, 1, 0, 4 );

    TextLabel12 = new QLabel( GroupBox1, "TextLabel12" );
    TextLabel12->setText( tr( "Very slow"  ) );
    TextLabel12->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)1, TextLabel12->sizePolicy().hasHeightForWidth() ) );
    TextLabel12->setMinimumSize( QSize( 45, 0 ) );
    TextLabel12->setMaximumSize( QSize( 45, 32767 ) );

    GroupBox1Layout->addWidget( TextLabel12, 0, 4 );
    QSpacerItem* spacer_10 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    GroupBox1Layout->addItem( spacer_10, 0, 3 );

    TextLabel11 = new QLabel( GroupBox1, "TextLabel11" );
    TextLabel11->setText( tr( "Slow"  ) );
    TextLabel11->setMinimumSize( QSize( 45, 0 ) );
    TextLabel11->setAlignment( int( QLabel::AlignCenter ) );

    GroupBox1Layout->addWidget( TextLabel11, 0, 2 );
    QSpacerItem* spacer_11 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    GroupBox1Layout->addItem( spacer_11, 0, 1 );

    tabLayout_3->addMultiCellWidget( GroupBox1, 0, 0, 0, 2 );
    QSpacerItem* spacer_12 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    tabLayout_3->addItem( spacer_12, 1, 2 );

    maxEdit = new QLineEdit( tab_3, "maxEdit" );

    tabLayout_3->addWidget( maxEdit, 1, 1 );

    TextLabel14 = new QLabel( tab_3, "TextLabel14" );
    TextLabel14->setText( tr( "Max download:"  ) );

    tabLayout_3->addWidget( TextLabel14, 1, 0 );

    maxActionGroup = new QButtonGroup( tab_3, "maxActionGroup" );
    maxActionGroup->setTitle( tr( "Max action:"  ) );
    maxActionGroup->setMinimumSize( QSize( 0, 45 ) );
    maxActionGroup->setMaximumSize( QSize( 32767, 45 ) );
    maxActionGroup->setEnabled( FALSE );
    maxActionGroup->setColumnLayout(0, Qt::Vertical );
    maxActionGroup->layout()->setSpacing( 0 );
    maxActionGroup->layout()->setMargin( 0 );
    maxActionGroupLayout = new QHBoxLayout( maxActionGroup->layout() );
    maxActionGroupLayout->setAlignment( Qt::AlignTop );
    maxActionGroupLayout->setSpacing( 6 );
    maxActionGroupLayout->setMargin( 11 );

    RadioButton1 = new QRadioButton( maxActionGroup, "RadioButton1" );
    RadioButton1->setText( tr( "Ignore"  ) );
    RadioButton1->setChecked( TRUE );
    maxActionGroupLayout->addWidget( RadioButton1 );

    RadioButton2 = new QRadioButton( maxActionGroup, "RadioButton2" );
    RadioButton2->setText( tr( "Remove"  ) );
    maxActionGroupLayout->addWidget( RadioButton2 );

    RadioButton3 = new QRadioButton( maxActionGroup, "RadioButton3" );
    RadioButton3->setText( tr( "Ask"  ) );
    RadioButton3->setEnabled( FALSE );
    maxActionGroupLayout->addWidget( RadioButton3 );

    tabLayout_3->addMultiCellWidget( maxActionGroup, 2, 2, 0, 2 );

    syncCheck = new QCheckBox( tab_3, "syncCheck" );
    syncCheck->setText( tr( "Sync with the server on delete"  ) );

    tabLayout_3->addMultiCellWidget( syncCheck, 3, 3, 0, 1 );

    leaveCheck = new QCheckBox( tab_3, "leaveCheck" );
    leaveCheck->setText( tr( "Leave on server"  ) );
    leaveCheck->setChecked( TRUE );

    tabLayout_3->addMultiCellWidget( leaveCheck, 4, 4, 0, 1 );

    sortCheck = new QCheckBox( tab_3, "sortCheck" );
    sortCheck->setText( tr( "Sort messages before downloading (d/l smallest first)"  ) );

    tabLayout_3->addMultiCellWidget( sortCheck, 5, 5, 0, 2 );
    TabWidget2->insertTab( tab_3, tr( "Advanced" ) );

    EditAccountDialogBaseLayout->addMultiCellWidget( TabWidget2, 0, 0, 0, 2 );

    // signals and slots connections
    connect( okButton, SIGNAL( clicked() ), this, SLOT( okClicked() ) );
    connect( cancelButton, SIGNAL( clicked() ), this, SLOT( cancelClicked() ) );
    connect( RadioButton2, SIGNAL( stateChanged(int) ), this, SLOT( maxGroupChanged(int) ) );
    connect( maxEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( maxEditChanged(const QString &) ) );
    connect( speedSlider, SIGNAL( valueChanged(int) ), this, SLOT( speedChanged(int) ) );
    connect( smtpServerEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( smtpServerChanged(const QString &) ) );
    connect( smtpPortEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( smtpPortChanged(const QString &) ) );
    connect( fromEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( fromChanged(const QString &) ) );
    connect( replyToEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( replyToChanged(const QString &) ) );
    connect( passCheck, SIGNAL( clicked() ), this, SLOT( passClicked() ) );
    connect( passEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( passChanged(const QString &) ) );
    connect( userEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( userChanged(const QString &) ) );
    connect( portEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( portChanged(const QString &) ) );
    connect( serverEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( serverChanged(const QString &) ) );
    connect( accountEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( nameChanged(const QString &) ) );
    connect( syncCheck, SIGNAL( clicked() ), this, SLOT( syncClicked() ) );
    connect( leaveCheck, SIGNAL( clicked() ), this, SLOT( leaveClicked() ) );
    connect( sortCheck, SIGNAL( clicked() ), this, SLOT( sortClicked() ) );
    connect( loginEdit, SIGNAL( textChanged(const QString&) ), this, SLOT( loginChanged(const QString &) ) );

    // tab order
    setTabOrder( TabWidget2, accountEdit );
    setTabOrder( accountEdit, serverEdit );
    setTabOrder( serverEdit, portEdit );
    setTabOrder( portEdit, userEdit );
    setTabOrder( userEdit, passEdit );
    setTabOrder( passEdit, passCheck );
    setTabOrder( passCheck, smtpServerEdit );
    setTabOrder( smtpServerEdit, smtpPortEdit );
    setTabOrder( smtpPortEdit, fromEdit );
    setTabOrder( fromEdit, replyToEdit );
    setTabOrder( replyToEdit, speedSlider );
    setTabOrder( speedSlider, maxEdit );
    setTabOrder( maxEdit, RadioButton1 );
    setTabOrder( RadioButton1, RadioButton2 );
    setTabOrder( RadioButton2, RadioButton3 );
    setTabOrder( RadioButton3, syncCheck );
    setTabOrder( syncCheck, leaveCheck );
    setTabOrder( leaveCheck, sortCheck );
    setTabOrder( sortCheck, okButton );
    setTabOrder( okButton, cancelButton );
}

/*
 *  Destroys the object and frees any allocated resources
 */
EditAccountDialogBase::~EditAccountDialogBase()
{
    // no need to delete child widgets, Qt does it all for us
}

void EditAccountDialogBase::cancelClicked()
{
    qWarning( "EditAccountDialogBase::cancelClicked(): Not implemented yet!" );
}

void EditAccountDialogBase::fromChanged(const QString &)
{
    qWarning( "EditAccountDialogBase::fromChanged(const QString &): Not implemented yet!" );
}

void EditAccountDialogBase::leaveClicked()
{
    qWarning( "EditAccountDialogBase::leaveClicked(): Not implemented yet!" );
}

void EditAccountDialogBase::maxEditChanged(const QString &)
{
    qWarning( "EditAccountDialogBase::maxEditChanged(const QString &): Not implemented yet!" );
}

void EditAccountDialogBase::maxGroupChanged(int)
{
    qWarning( "EditAccountDialogBase::maxGroupChanged(int): Not implemented yet!" );
}

void EditAccountDialogBase::nameChanged(const QString &)
{
    qWarning( "EditAccountDialogBase::nameChanged(const QString &): Not implemented yet!" );
}

void EditAccountDialogBase::loginChanged(const QString &)
{
    qWarning( "EditAccountDialogBase::loginChanged(const QString &): Not implemented yet!" );
}

void EditAccountDialogBase::okClicked()
{
    qWarning( "EditAccountDialogBase::okClicked(): Not implemented yet!" );
}

void EditAccountDialogBase::passChanged(const QString &)
{
    qWarning( "EditAccountDialogBase::passChanged(const QString &): Not implemented yet!" );
}

void EditAccountDialogBase::passClicked()
{
    qWarning( "EditAccountDialogBase::passClicked(): Not implemented yet!" );
}

void EditAccountDialogBase::portChanged(const QString &)
{
    qWarning( "EditAccountDialogBase::portChanged(const QString &): Not implemented yet!" );
}

void EditAccountDialogBase::serverChanged(const QString &)
{
    qWarning( "EditAccountDialogBase::serverChanged(const QString &): Not implemented yet!" );
}

void EditAccountDialogBase::replyToChanged(const QString &)
{
    qWarning( "EditAccountDialogBase::replyToChanged(const QString &): Not implemented yet!" );
}

void EditAccountDialogBase::smtpPortChanged(const QString &)
{
    qWarning( "EditAccountDialogBase::smtpPortChanged(const QString &): Not implemented yet!" );
}

void EditAccountDialogBase::smtpServerChanged(const QString &)
{
    qWarning( "EditAccountDialogBase::smtpServerChanged(const QString &): Not implemented yet!" );
}

void EditAccountDialogBase::sortClicked()
{
    qWarning( "EditAccountDialogBase::sortClicked(): Not implemented yet!" );
}

void EditAccountDialogBase::speedChanged(int)
{
    qWarning( "EditAccountDialogBase::speedChanged(int): Not implemented yet!" );
}

void EditAccountDialogBase::syncClicked()
{
    qWarning( "EditAccountDialogBase::syncClicked(): Not implemented yet!" );
}

void EditAccountDialogBase::userChanged(const QString &)
{
    qWarning( "EditAccountDialogBase::userChanged(const QString &): Not implemented yet!" );
}


