/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __GroupObject__
#define __GroupObject__

#include <clientvfs.h>
#include <qstringlist.h>
#include <qfont.h>
#include <qsize.h>
#include <qpoint.h>
#include <qdatetime.h>
#include <vobject.h>
#include <vobjectfactory.h>
#include <qvariant.h>
#include <queryprocessor.h>


/**
 *	the group (list of E-mails + nume + classes) class
 */
 
 
class GroupObject : public VObject
{
	friend class ClientVFS;
	protected:
		GroupObject(QString _path, QByteArray &_data);
		GroupObject(QString _path);
	public:
		~GroupObject();
		/**
		 *	Methods for accessing the fields
		 */
		QString groupName();
		void setGroupName(QString);
		QStringList members();
		void setMembers(QStringList);
		QStringList classes();
		void setClasses(QStringList);
		QString icon();
		void setIcon(QString);
		/**
		 * object marshalling methods (overloaded from VObject, so that 
		 * save() and sync() work)
		 */
		QByteArray _stream();
		void _narrow(const QByteArray &);
		/**
		 * query handling
		 */
		virtual bool getProperty(QString query, Any &property);
		virtual bool setProperty(QString query, Any &property);
		virtual QueryProcessor::QueryType queryType(QString query);
	private:
		/**
		 *	internal data
		 */
		QString 		_groupName;					// group's name
		QStringList _members;				// all the members of the group
		QStringList _classes;				// all the classes which qualify the group
		QString			_icon;					// grou's icon
		QString _category;
};

class GroupObjectFactory : public VObjectFactory
{
	public:
		GroupObject *_new(QString _path, QByteArray &_data);
		GroupObject *_new(QString _path);
};

#endif
