/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <commbinder.h>
#include <accounts.h>
#include <qstring.h>
#include <qcstring.h>
#include <qobject.h>
#include <commframe.h>
#include <servercommgate.h>
#include <commands.h>
#include <clientrmi.h>

static CommBinder *inst;

CommBinder::CommBinder():QObject()
{
	lastSeqTag=0;
	printf("Commbinder instance activated\n");
}

CommBinder::~CommBinder()
{
}

CommBinder *CommBinder::thisInstance()
{
	return inst?inst:inst=new CommBinder();
}

bool CommBinder::send(QString binding, CommFrame &inFrame, CommFrame &outFrame)
{
	if(binding!="thisInstance") 
		return false;
	inFrame.sequenceTag=lastSeqTag++;
	callSend(inFrame, outFrame);
	return true;
}

bool CommBinder::send(QString binding, CommFrame &inFrame)
{
	if(binding!="thisInstance") 
		return false;
	inFrame.sequenceTag=lastSeqTag++;
	callSend(inFrame);
}

QString CommBinder::lastError()
{
	return err;
}
		
bool CommBinder::connect(QString binding)
{
	if(binding=="thisInstance")
		return true;
	return false;
}

bool CommBinder::disconnect(QString binding)
{
	return false; // can't disconnect from the loopback server :)
}
		
bool CommBinder::connected(QString binding)
{
	if(binding=="thisInstance")
		return true;
	return false;
}

QStringList CommBinder::activeConnections()
{
	QStringList connections;
	connections.append("thisInstance");
	return connections;
}

void CommBinder::initLoopback()
{
	// nothing here yet
}

bool CommBinder::socketSend(QString binding, CommFrame &inFrame, CommFrame &outFrame)
{
	return false;
}

bool CommBinder::socketSend(QString binding, CommFrame &inFrame)	
{
	return false;
}

bool CommBinder::callSend(CommFrame &inFrame, CommFrame &outFrame)
{
	ServerCommGate::thisInstance()->callReceive(inFrame, outFrame);
	return true;
}

bool CommBinder::callSend(CommFrame &inFrame)
{
	ServerCommGate::thisInstance()->callReceive(inFrame);
	return true;
}

void CommBinder::receive(CommFrame &inFrame)
{
	if(inFrame.commandCode==MagellanComm::RMICall)
		ClientRMI::ref()->__process(inFrame);
	else
		emit messageReceived(inFrame); // this is a notifier call, integrate in the Qt event loop
}

void CommBinder::receive(CommFrame &inFrame, CommFrame &outFrame)
{
	ClientRMI::ref()->__process(inFrame, outFrame);
}
