/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <queryprocessor.h>
#include <brokeriface.h>
#include <clientvfs.h>
#include <qstring.h>
#include <qdict.h>
#include <vobject.h>
#include <any.h>

static QueryProcessor *inst;

QueryProcessor::QueryProcessor()
{
	// nothing here
}

QueryProcessor::~QueryProcessor()
{
	// nothing here
}

QueryProcessor *QueryProcessor::thisInstance()
{
	return inst?inst:inst=new QueryProcessor();
}

bool QueryProcessor::validQuery(QString q)
{
	// parse the query
	int k=q.find("?");
	if(k<2)
	{
		err="Query does not contain a valid url";
		return false; // there is nothing to apply the query onto
	}
	QString query=q.mid(k+1), url=q.left(k);
	QStringList params=QStringList::split('.', query);
	if(!params.count())
	{
		err="Query has no data";
		return false;
	}
}

bool QueryProcessor::getData(QString url, QByteArray &data)
{
  bool bRet=false;
  
  if(validQuery(url))
  {
    VObject* objectRef=ClientVFS::thisInstance()->objectRef(url);
    QString query=url.right(url.findRev("?"));
    if(objectRef && 
      QueryProcessor::InvalidQuery==objectRef->queryType(query))
    {
      Any property;
      objectRef->getProperty(query, property);
      data=property.rawData();
      bRet=true;
    }
  }
  
	return bRet;
}

bool QueryProcessor::setData(QString url, const QByteArray &data)
{
  bool bRet=false;
  
  if(validQuery(url))
  {
    VObject* objectRef=ClientVFS::thisInstance()->objectRef(url);
    QString query=url.right(url.findRev("?"));
    if(objectRef && 
      QueryProcessor::InvalidQuery==objectRef->queryType(query))
    {
      Any property;
      if(property.load(data))
      {
        objectRef->setProperty(query, property);
        bRet=true;
      }
    }
  }
  
	return bRet;
}

QString QueryProcessor::lastError()
{
	return err;
}
