/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/**
 * Changed by Eugen C. for speeding reasons.
 */

#ifndef __VirtualFolder__
#define __VirtualFolder__

#include <qstring.h>
#include <templateview.h>
#include <qlist.h>
#include <qdict.h>
#include <qstringlist.h>
#include <vreference.h>

/*
This class contains the definition of a folder, as seen by a Magellan client.
It contains three kinds of information:

1) the folder URL, which holds a protocol, binding and client folder path (the server path is separate)
2) the main view pointer (whose existence is synced with the folder) and the alternative views
3) the main tree widget pointer and the alternative tree widgets
4) a map of child objects
*/

class VObject;
class VCacheObject;
class ClientVFS;

class VFolder : public VReference
{
	friend class ClientVFS;
	protected:
		VFolder(QString path);			
	public:
		virtual ~VFolder();
			
		// info methods
		QString name();     			// folder name
		QString url(); 						// folder url, in a type://path fashion
		QString type(); 					// folder type
		QString viewType();
		QString mimeType();
		QString binding();  			// binding ("thisInstance", QString::null for local folders or an account name)
		QString path();						// folder path
		QString serverPath();    	// server (remote) path
		
		QString flags();
		void setFlags(const QString &);
		
		// (re)sets the folder type
		void setType(QString);

		void setViewType(QString);
		
		void setMimeType(QString);
		
		// (re)sets the folder binding (exclusive for Magellan servers, see commbinder.h)
		void setBinding(QString);
		
		// (re)sets the server path
		void setServerPath(QString);
				
		/** Children objects like a QDict.*/
		QDict<VObject>& objectDict();
    /** Children objects like a QList.*/
		QList<VObject>& objectList();		
		/** Check if it is a simple object or not.*/
    bool isSimpleObject(const QString objectName) const;
//		QStringList entryList(bool all=false);

		bool addObject(QString);
		bool addObject(VObject *);
		bool removeObject(QString);
		bool removeObject(VObject *);
		bool removeObjectRef(VObject *);
		
		VCacheObject *entryCacheBlock();
	private:
		QString folderPath, folderType, folderViewType, folderMimeType, folderBinding, folderSPath, folderFlags;
		/** The list of objects in a hystorical order :).*/
		QList<VObject> objectsList;
		/** The list of objects sorted by name, usefull for checking.*/
		QDict<VObject> objectsDict;
		VCacheObject *folderCache;
};

#endif

