/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __Any__
#define __Any__

#include <qcstring.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qdatastream.h>
#include <qfont.h>
#include <qpoint.h>
#include <qsize.h>
#include <qdatetime.h>
#include <dateclass.h>

/* 

Type-safe encapsulation class
We use this because:

(1) Qt data marshalling doesn't do type checking
(2) QVariant doesn't encapsulate QByteArrays, and this is needed for MQL if we want to manipulate pure binary data

*/

class Any
{
	friend QDataStream& operator>>(QDataStream &, Any &);
	friend QDataStream& operator<<(QDataStream &, const Any &);
	public:
		// encapsulation constructors
		Any();
		Any(int);
		Any(double);
		Any(const QByteArray &);
		Any(const QDateTime &);
		Any(const DateClass &);
		Any(const QFont &);
		Any(const QPoint &);
		Any(const QSize &);
		Any(const QString &);
		Any(const QStringList &);
		
		// conversions
		int toInt();
		double toDouble();
		QByteArray toByteArray();
		QDateTime toDateTime();
		DateClass toDateClass();
		QFont toFont();
		QPoint toPoint();
		QSize toSize();
		QString toString();
		QStringList toStringList();
		
		// cast methods
		operator int();
		operator double();
		operator QByteArray();
		operator QDateTime();
		operator DateClass();
		operator QFont();
		operator QPoint();
		operator QSize();
		operator QString();
		operator QStringList();
		
		// assignment and comparison
		const Any& operator=(const Any&);
		bool operator==(Any &) const;
		bool operator!=(Any &) const;
		
		// type information
		enum Type { Invalid, ByteArray, StringList, String, Int, Double, Font, Point, Size, DateTime, ExtDateTime };
		Type type();
		QString typeName();
		bool canCast(Type);
		bool canCast(const QString&);
		bool isValid();
		static bool isValidType(Type);
		static bool isValidTypeName(const QString&);
		
		// raw data loading and saving
		bool load(const QByteArray &);
		const QByteArray& rawData();
		void clear();
	private:
		QByteArray data;
};

#endif
