/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <qheader.h>
#include <qstring.h>
#include <qlistview.h>
#include <stdio.h>

#include <ataddressbook.h>
#include <addressbookview.h>
#include <addressclass.h>
#include <contacttodialogbase.h>
#include <contacttogroupdialog.h>
#include <groupobj.h>

//#define DEBUG_CTG

#define IDSTRING "ContactToGroupDialog: "

// make it Modal
ContactToGroupDialog::ContactToGroupDialog(QString mail, QWidget *parent=0) :
	ContactToGroupDialogBase(parent, 0, true)
{
	_contact=mail;
	abView->initMode(AddressBook::Groups | AddressBook::ListOnly, _contact, false);
	populateDialog();
	connect(abView, SIGNAL(clicked(QListViewItem *)),
		this, SLOT(groupSelected(QListViewItem *)));
	connect(abView, SIGNAL(returnPressed(QListViewItem *)),
		this, SLOT(groupSelected(QListViewItem *)));
}

bool ContactToGroupDialog::checkGroups(QString mail)
{
	AddressBookView *tempView= new AddressBookView(0);
	tempView->initMode(AddressBook::Groups | AddressBook::ListOnly, mail, false);
	bool result=tempView->childCount();
	delete tempView;
	return result;
}

void ContactToGroupDialog::addClicked()
{
	//scanning the groups for name...
	GroupObject *obj=AddressBook::thisInstance()->getGroupByName(abView->currentItem()->text(0));
#ifdef DEBUG_CTG
	printf(IDSTRING"Group name: <%s>\n", (const char *)abView->currentItem()->text(0));
	printf(IDSTRING"Object is: %p\n",obj);
#endif
	if(!obj)
	{
		printf(IDSTRING"Error: invalid group <%s>\n", (const char *)abView->currentItem()->text(0));
	}
	else
	{
		QStringList m=obj->members();
		m.append(_contact);
		obj->setMembers(m);
		obj->save();
//		AddressBook::thisInstance()->removeGroup(obj->url());
		AddressBook::thisInstance()->addGroup(obj);		
	}
	close();
}
void ContactToGroupDialog::cancelClicked()
{
	close();
}
void ContactToGroupDialog::groupSelected(QListViewItem *item)
{
	QStringList sl;
	abView->getSelectedEmailList(sl);
	membersList->clear();
#ifdef DEBUG_CTG
	printf(IDSTRING"Selected Mails: %d\n",sl.count());
#endif
	for(int i=0;i<sl.count();i++)
	{
#ifdef DEBUG_CTG
		printf(IDSTRING"\t <%s>\n",(const char *)sl[i]);
#endif
		AddressClass *ac= new AddressClass((const char *)sl[i]);
		QListViewItem *it=new QListViewItem(membersList);
		it->setText(0,QString((const char *)ac->translated_name)+"   ");
		it->setText(1,(const char *)ac->email);
		delete ac;
	}
}

void ContactToGroupDialog::populateDialog()
{
	membersList->header()->hide();
//	membersList->setColumnAlignment(1,Qt::AlignHCenter);
	membersList->setAllColumnsShowFocus(true);
}
