/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <genericeditdialog.h>
#include <videotoolbox.h>

extern VideoToolBox vtb;

GenericEditDialog::GenericEditDialog(QWidget *parent, QString name) :
	QMainWindow(parent, name, WType_Modal | WStyle_Dialog) 
{
	printf(" Enter constructor\n");
	intValidator= new QIntValidator(this);
	doubleValidator= new QDoubleValidator(this);
	lines=NULL;
	labels=NULL;
	printf(" Exit constructor\n");
}

GenericEditDialog::~GenericEditDialog()
{
	if(lines) {delete lines; lines=NULL; }
	if(labels) { delete labels; labels=NULL; }
}

QStringList GenericEditDialog::getResults(bool *ok, QString name,
			QStringList titles,
			QStringList old, QStringList types, int maxEditSize, QWidget *parent)
{
	GenericEditDialog *ge=new GenericEditDialog(parent, name);
	ge->setUpDialog(titles, old, types, maxEditSize);
//	ge.show();
}
void GenericEditDialog::setUpDialog(QStringList titles, QStringList old,
			QStringList types,int maxEditSize)
{
	oldResults=results=old;
	int DX,DY;
	int dx, dy;
	int align=vtb.getMaxAlign(titles);
	printf(" Align: %d\n", align);
	// sets the fonts
	vtb.setUpFonts(QFont("helvetica",12, QFont::Normal));
	// sets the dialog's geometry
	w=10+10+align+maxEditSize;
	h=10+10+(vtb.fontHeight()+vtb.offsetY())*(titles.count()+1)-vtb.offsetY();
	if(w<200) w=200;
	setFixedSize(w,h);
	printf(" Width: %d, Height: %d\n", width(), height());
	dx=dy=10;
	// allocating the buffers
	labels = new (QLabel *)[titles.count()];
	lines = new (QLineEdit *)[titles.count()];
	for(int i=0;i<titles.count();i++)
	{
		labels[i] = vtb.setUpLabelSize(this, titles[i], align,
		&dx, &dy);
		lines[i] = vtb.setUpLineEdit(this, maxEditSize, vtb.fontHeight(),
		&dx, &dy);
		lines[i]->setText(old[i]);
		if(types[i].lower()=="int") lines[i]->setValidator(intValidator);
		if(types[i].lower()=="double") lines[i]->setValidator(doubleValidator);
		dx=10; dy+=vtb.fontHeight()+vtb.offsetY();
	}
	ok=new QPushButton(this);
	ok->setText("&Ok");
	ok->setAutoDefault(true);
	ok->setDefault(true);
	ok->setGeometry(width()-190,dy,80,vtb.fontHeight());
	cancel=new QPushButton(this);
	cancel->setText("&Cancel");
	cancel->setGeometry(width()-90,dy,80,vtb.fontHeight());
	connect(ok,SIGNAL(clicked()), this, SLOT(okClicked()));
	connect(cancel,SIGNAL(clicked()), this, SLOT(cancelClicked()));
	printf(" Ready\n");
}

void GenericEditDialog::okClicked()
{
	for(int i=0;i< results.count();i++)
		results[i]=lines[i]->text();
	emit end(results);
	close(true);
}
void GenericEditDialog::cancelClicked()
{
	emit end(oldResults);
	close(true);
}
