/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef HAS_VIDEO_TOOLBOX_HPP
	#define HAS_VIDEO_TOOLBOX_HPP

#include <stdio.h>
#include <qfontmetrics.h>
#include <qfont.h>
#include <qlabel.h>
#include <ebutton.h>
#include <etogglebutton.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qlistbox.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qtextview.h>


class VideoToolBox
{
	unsigned char_size;
	unsigned font_height;
	unsigned offset_def;
	unsigned offset_y;
	
public:
	VideoToolBox() { fm = 0; };
	/**
	 *	This function is used to set up right the fotn related dimensions
	 */
	void setUpFonts(QFont font);

	/**
	 *	@return the maximum character size.
	 */
	unsigned charSize();
	/**
	 * @return the maximum char height + some offset to make the char fit in nice.
	 */
	unsigned fontHeight();
	/**
	 *	@return the default X offset (arbitrary defined to 5)
	 */
	unsigned offsetDef();
	/**
	 *	@return the default Y offset (arbitrary defined to 8)
	 */
	unsigned offsetY();
	/**
	 * @return the string length based on the characters' dimensions
	 */
	unsigned stringLength(QString str);
	/**
	 *	This is for setting up the label in a dialogbox
	 *	Parameters:
	 *		QWidget *parent - the parent widget
	 *		QString text - the text to be displayed & also used for computing the 
	 *									 geometry.
	 *	It updates the dx variable.
	 *	@return a QLabel containing the new widget
	 */
	QLabel *setUpLabel( QWidget *parent, QString text,
		int *dx=NULL, int *dy=NULL);
	/**
	 *	Parameters:
	 *		QWidget *parent - the parent widget
	 *		QString pix - pixmap file to be displayed as background
	 *	It updates the dx variable.
	 *	@return a QLabel containing the new widget
	 */
	QLabel *setUpLabelBgPixmap( QWidget *parent, QString text, QString pix,
		int X, int Y, int *dx=NULL, int *dy=NULL);
	/**
	 *	This is for setting up the label in a dialogbox. It is the same with the
	 * previous one, but it has an extra parameter stating the label's length.
	 * It is used for setting up labels with different textes and the same
	 * lengths.
	 *	Parameters:
	 *		QWidget *parent - the parent widget
	 *		QString text - the text to be displayed & also used for computing the 
	 *									 geometry.
	 *		int size		 - the length of the label
	 *	It updates the dx variable.
	 *	@return a QLabel containing the new widget
	 */
	QLabel *setUpLabelSize( QWidget *parent, QString text,
		int size, int *dx=NULL, int *dy=NULL);
	/**
	 *	One can use this method to set up nicely one QLineEdit variable.
	 *
	 *	Parameters:
	 *		QWidget *parent - the parent widget
	 *		int length - the QLineEdit's length
	 *		int height		 - the QLineEdit's height
	 *	It updates the dx variable.
	 *	@return a QLineEdit containing the new widget
	 */
	QLineEdit *setUpLineEdit( QWidget *parent,
		int length, int height, int *dx=NULL, int *dy=NULL);
		
	/**
	 *	One can use this function to set up nicely one QMultiLineEdit variable.
	 *
	 *	Parameters:
	 *		QWidget *parent - the parent widget
	 *		int length - the QMultiLineEdit's length
	 *		int height		 - the QMultiLineEdit's height
	 *	It updates the dx variable.
	 *	@return a QMultiLineEdit containing the new widget
	 */
	QMultiLineEdit *setUpMultiLineEdit( QWidget *parent,
		int length, int height, int *dx=NULL, int *dy=NULL);
	/**
	 *	One can use this method to set up nicely one QComboBox variable.
	 *
	 *	Parameters:
	 *		QWidget *parent - the parent widget
	 *		bool flag - if true then the widget will be a RW. Else is a ReadOnly
	 * (ie. you cannot edit the variables in it).
	 *		int size - the QComboBox's length
	 *	It updates the dx variable.
	 *
	 */
	QComboBox *setUpCombo( QWidget *parent, bool flag,
		int size, int *dx=NULL, int *dy=NULL);
	/**
	 *	reparent is used to reparent a widget onto a frame
	 *	The parameters are:
	 *	QWidget *widget - the widget to be reparened
	 *	QWidget *frame	- the new parent frame
	 *	int index - a variable for stating the new parent (preferable in the
	 *							class itself). It acts like a flag for not reparenting
	 *							twice on the same parent...
	 *	int request - the frame's index 
	 *				(see vcarddialog.cpp (line 414) for details)
	 */
	bool reparent(QWidget *widget, QWidget *frame, int &index, int request);
	/**
	 *	setUpBoxContent is used to add something or set the active item in a 
	 *		QComboBox.
	 *		The parameters are:
	 *	QComboBox *box - the box
	 *	QString str	- the string to be added or set as active if already exists
	 *		You need:
	 *	miscfunctions.h included (for enhancedSplit)
	 */
	void setUpBoxContent(QComboBox *box, QString str);
	/**
	 *	This method is for replacing the bunch of lines needed for setting 
	 * up a KFButton.
	 *	Parameters:
	 *		- parent							: the parent widget
	 *		- font							: the font for the text
	 *		- normalPix					: the pixmap to be displayed in the normal state
	 *		- focusPix					: the pixmap to be displayed when focused
	 *													(mouseover)
	 *		- clickedPix				: the pixmap to be displayed when clicked
	 *		- normalFrame				: the frame when normal
	 *		- focusFrame				: the frame when mouse over
	 *		- clickedFrame			: the frame when left btton clicked
	 *		- text							: the text to be displayed (if any)
	 *		- x,y								: the starting coords (upper left corner) relative
	 *													to the parent widget (dx and dy used)
	 *		- offsetX, offsetY	: the width and height
	 */
	EButton *setUpEButton( QWidget *parent, QFont font,
		QString normalPix, QString focusPix, QString clickedPix,
		int normalFrame, int focusFrame, int clickedFrame,
		QString text,
		int x, int y, int offsetX, int offsetY);
	/**
	 *	This method is for replacing the bunch of lines needed for setting 
	 * up a EEEToggleButton.
	 *	Parameters:
	 *		- parent							: the parent widget
	 *		- font							: the font for the text
	 *		- normalPix					: the pixmap to be displayed in the normal state
	 *		- focusPix					: the pixmap to be displayed when focused
	 *													(mouseover)
	 *		- clickedPix				: the pixmap to be displayed when clicked
	 *		- normalFrame				: the frame when normal
	 *		- focusFrame				: the frame when mouse over
	 *		- clickedFrame			: the frame when left btton clicked
	 *		- normalColor				: the normal background color
	 *		- toggledColor			: the toggled background color
	 *		- text							: the text to be displayed (if any)
	 *		- x,y								: the starting coords (upper left corner) relative
	 *													to the parent widget (dx and dy used)
	 *		- offsetX, offsetY	: the width and height
	 */
	EToggleButton *setUpToggleButton( QWidget *parent, QFont font,
		QString normalPix, QString focusPix, QString clickedPix,
		int normalFrame, int focusFrame, int clickedFrame,
		QColor normalColor, QColor toggledColor,
		QString text,
		int x, int y, int offsetX, int offsetY, bool toggled);
	/**
	 * This is for setting up a QListBox
	 *	Params:
	 *		parent - the parent widget
	 *		font - the font with which the text will be written
	 *		width, height - the box's dimensions
	 */
	QListBox *setUpList(QWidget *parent, QFont font,
		int width, int height, int *dx=NULL, int *dy=NULL);
	/**
	 * This method is for setting up a QPushButton
	 *	Params:
	 *		parent - the parent widget
	 *		text - the text to be displayed in the button
	 *		width, height - the button's dimensions
	 */
	QPushButton *setUpQPushButton( QWidget *parent, QString text,
		int width, int height, int *dx=NULL, int *dy=NULL);
	/**
	 * This method is for setting up a QRadioButton
	 *	Params:
	 *		parent - the parent widget
	 *		text - the text to be displayed in the button
	 */
	QRadioButton *setUpQRadioButton( QWidget *parent, QString text,
		int *dx=NULL, int *dy=NULL);
	/**
	 * This method is for setting up a QCheckBox
	 *	Params:
	 *		parent - the parent widget
	 *		text - the text to be displayed in the button
	 */
	QCheckBox *setUpQCheckBox(QWidget *parent, QString text,
		int *dx=NULL, int *dy=NULL);
	/**
	 * This method is for setting up a QTextView (HTML)
	 *	Params:
	 *		parent - the parent widget
	 *		frameStyle - the frame style
	 *		bgcolor - the background color
	 *		text - the text to be displayed in the button
	 *		width, height - widget's dimensions
	 *		dx, dy - the offset for setGeometry
	 */
	QTextView *setUpTextView(QWidget *parent, int frameStyle, QColor bgcolor,
		QString text, int width, int height, int dx, int dy);
	int getMaxAlign(QStringList strings, bool addColon=false);
	
	static void centerWindow(QWidget *);
private:
	QFont qf;
	QFontMetrics *fm;

};

QFont QPxFont(QString hint, int pxSize = 10, int weight = QFont::Normal);

#endif
