/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __TEXTHTML_H
#define __TEXTHTML_H

#include <qstring.h>
#include <qstringlist.h>
#include <qstrlist.h>
#include <qdict.h>

class TextHtmlConvertor
{
	public:
		TextHtmlConvertor();
		void init();
		void text2html(QString &msg, QString tmpl="default");
		void html2text(QString &dws);
		void html2html(QString &msg);
		/** QCString support.*/
		void text2html(QCString &msg, QString tmpl="default");
		void html2text(QCString &dws);
		void html2html(QCString &msg);
	private:
		void readReply();
		void readWrote();
		void readPages();
		void readReplacements();
		
		void updateReply(QString &);
		void updateWrote(QString &);
		void updateCustom(QString &);
		void updateGeneric(QString &, QString tag, QString r1, QString r2);
		
		// see text only
		bool seeText;
		long maxTextLength;
		// reply replacements
		QString replyBeginTag;
		QString replyEndTag;
		QString replyMiddleTag;
		QString replyTabulator;
		bool replyDuplicateTabulator;
		
		// "Wrote:" replacements
		QString wroteBeginTag;
		QString wroteEndTag;
		
		// the pages
		QDict<QString> startPagesDict;
		QDict<QString> endPagesDict;
		
		// the CSS-s (and other HTML replacements)
		QDict<QString> cssDict;
		QDict<QString> beginHTMLDict;
		QDict<QString> endHTMLDict;
		
		QStrList activeRules;
		bool addressDetection;
};

#endif
