/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <addresslistclass.h>
#include <qtextstream.h>

AddressListClass::AddressListClass(const QCString &t)
{
  QStrList s;
  char c;
  QCString token;
  bool nesting=false;
  QTextStream txt(t, IO_ReadOnly);
  while(!txt.atEnd())
  {
    txt.readRawBytes(&c, 1);
    if(c=='"') nesting=!nesting;
    
    if(c==',' && !nesting)
    {
      s.append(token);
      token.truncate(0);
    }
    else
      token+=c;
  }
  if(!token.isEmpty())
    s.append(token);
  
  for(unsigned i=0;i<s.count();i++)
  {
    QCString t=s.at(i);
    AddressClass *k=new AddressClass(t);
    addrList.append(k);
  }
//  addrList.setAutoDelete(true); // don't uncomment! (apparently Qt bug)
}

AddressClass AddressListClass::operator[](int index)
{
  return *(addrList.at(index));
}

int AddressListClass::count()
{
  return addrList.count();
}

AddressListClass::operator QStrList()
{
  QStrList t;
  for(unsigned i=0;i<addrList.count();i++)
    t.append((QCString)(*(addrList.at(i))));
  return t;
}

QStrList AddressListClass::toQStrList()
{
	return operator QStrList();
}

AddressListClass::operator QCString()
{
  QCString t;
  
  for(unsigned i=0;i<addrList.count();i++)
  {
		QCString address=addrList.at(i)->toQCString();
		if(!address.isEmpty())
			t+=address+", ";
  }
  if(!t.isEmpty())
    t.truncate(t.length()-2);
  return t;
}

QCString AddressListClass::toQCString()
{
	return operator QCString();
}

void AddressListClass::addAddress(AddressClass *newAddress)
{
	addrList.append(newAddress);
}

void AddressListClass::clear()
{
	addrList.clear();
}

QTextStream& operator<<(QTextStream &s, AddressListClass &a)
{
  QCString t=(QCString)a;
  s<<t;
  return s;
}




