/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __NetPOP3__
#define __NetPOP3__

#include <netprotocol.h>
#include <string>
#include <vector>
#include <stlutil.h>

class NetPOP3 : protected NetProtocol, protected STLUtil
{
	public:
		NetPOP3();
		NetPOP3(const char *);
		bool connect(const string &host, int port=110);
		bool user(const string &username);
		bool pass(const string &password);
		bool dele(int message);
		bool rset();
		bool stat(unsigned &messagecount, unsigned &totalsize);
		int last();
		int list(int message);
		bool list(vector<int> &);
		string uidl(int message);
		bool uidl(vector<string> &);
		bool top(int message, int lines, string &);
		bool retr(int message, string &);
		void quit();
		
		bool isConnected();
		bool dotRead(string &);
		NetSocket &socket();
		string error();
		/** Check if the client gets the end of response.*/
		bool checkEndOfResponse(const string&) const;
	private:
		string pop3_error;
};

#endif

