/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <accountmanager.h>
#include <kconfig.h>

extern KConfig *GlobalConfig;

AccountManager *AccountManager::thisInstance;

AccountManager *AccountManager::ref()
{
	if(!thisInstance)
		thisInstance=new AccountManager::AccountManager();
	return thisInstance;
}

AccountManager::AccountManager()
{
	loadAccounts();
}

void AccountManager::loadAccounts()
{
	// cleanup
	accDict.setAutoDelete(true);
	accDict.clear();
	 
  // (re)initialize accounts
  defaultAccount=0;
  GlobalConfig->setGroup("Receive Options");
  QString defacc=GlobalConfig->readEntry("Default");
  QStrList acclist;
  GlobalConfig->readListEntry("Accounts", acclist);
  for(QStrListIterator it(acclist); it.current(); ++it)
  {
    Account *t=new Account((*it));
    if((*it)==defacc) 
			defaultAccount=t;
    accDict.insert((*it), t);
  }
}

QString AccountManager::getAccountHostName(QString acc)
{
	QString ret;
	Account *a=accDict[QString(acc)];
	if(a)
		ret=a->server;
	return ret;
}

QString AccountManager::getAccountLogin(QString acc)
{
	QString ret;
	Account *a=accDict[QString(acc)];
	if(a)
		ret=a->user;
	return ret;
}

QString AccountManager::getAccountPassword(QString acc)
{
	QString ret;
	Account *a=accDict[QString(acc)];
	if(a)
		ret=a->password;
	return ret;
}

int AccountManager::getAccountPort(QString acc)
{
	int ret=0;
	Account *a=accDict[QString(acc)];
	if(a)
		ret=a->port;
	return ret;
}

Account *AccountManager::getDefaultAccount()
{
	Account *ret=defaultAccount;
	return ret;
}

Account *AccountManager::getAccount(QString accname)
{
	Account *ret=accDict[accname];
	return ret;
}

QStringList AccountManager::getAccountNames(int iType)
{
	QStringList ret;
	QDictIterator<Account> accit(accDict);
	while(accit.current())
	{
	  if( iType==Account::UNDEFINE || iType==(*accit).type )
		  ret.append(accit.currentKey());
		++accit;
	}
	return ret;
}

void AccountManager::addAccount(Account *acc)
{
	if(acc) accDict.insert(acc->accname, acc);
}

void AccountManager::deleteAccount(Account *acc)
{
	if(acc) accDict.remove(acc->accname);
}

void AccountManager::deleteAccount(QString name)
{
	if(!name.isEmpty()) accDict.remove(name);
}

void AccountManager::setDefaultAccount(Account *acc)
{
	if(acc && accDict[acc->accname]) defaultAccount=acc;
}

void AccountManager::setDefaultAccount(QString name)
{
	Account *acc;
	if(!name.isEmpty() && (acc=accDict[name])) defaultAccount=acc;
}
