/***************************************************************************
                commandsprocessor.h  -  a smart command list
                             -------------------
    begin                : Thu Jul  5 17:35:17 EEST 2001
    copyright            : (C) 2001 by Eugen C.
    email                : eug@thekompany.com
 ***************************************************************************/

#ifndef COMMANDSPROCESSOR_H
#define COMMANDSPROCESSOR_H

#include <list.h>

typedef struct CommandStruct
{
  unsigned type;
  string account; // IMAP
  string mailbox; // IMAP
  string other; // other info like Aethera server url , view type etc.
  string parameters;
} COMMAND_STRUCT;

typedef list<COMMAND_STRUCT> CommandsList;
typedef CommandsList::iterator CommandsListIterator;

//typedef COMMAND_STRUCT* COMMAND_REF;
//typedef hash_multimap<unsigned, COMMAND_REF> CommandsTypes;
//typedef CommandsTypes::Iterator CommandsTypesIterator;

class CommandProcessor
{
  public:
    CommandProcessor();
    ~CommandProcessor();
    /** Insert a new command in the list.*/
    bool insertCommand(unsigned type, string account, string mailbox="xxxx", string other="yyyy", string parameters="zzzz");
    /** Execute the first command from the list.*/
    bool popCommand(COMMAND_STRUCT& newCommand);
    /** Check if the list is empty or not.*/
    bool isEmpty();
    /** Clear the list.*/
    void clear();

  private:
    /** Return the first command which correspond with type and account.*/
    CommandsListIterator find(unsigned type, string account);
    /** The list of commands.*/
    CommandsList commands;

    COMMAND_STRUCT lastCommand;

};

#endif








