/***************************************************************************
                          imap4thread.cpp  -  IMAPv4 thread
                             -------------------
    begin                : Wed Feb  7 12:23:00 EET 2001
    copyright            : (C) 2001 by theKompany (www.thekompany.com>
    author               : Eugen Constantinescu
    email                : eug@thekompany.com
 ***************************************************************************/

#include <pthread.h>
#include <semaphore.h>
#include <incomingauthstructure.h>
#include <string>
#include <vector>
#include <imap4handler.h>
#include <netimap4.h>
#include <algorithm>
#include <unistd.h>
#include <limits.h>
#include <time.h>
#include <stdio.h>

#ifdef OS_LINUX
  #include <asm/errno.h>
#else
  #ifdef OS_FREEBSD
    #include <errno.h>
  #endif
#endif

#ifndef IMAP_PROGRESS_SIGNAL
#define IMAP_PROGRESS_SIGNAL 1
#endif

static string account="";
static NetIMAP4* client=0;
	
void showCommand(NetIMAP4 *client)
{
  printf("\n-----------------------------\n");

  if( client )
    client->showStatus();

  printf("\naccount=%s", IMAP4Handler::commandData.account.c_str());
  printf("\nmailbox=%s", IMAP4Handler::commandData.mailbox.c_str());
  printf("\nother=%s", IMAP4Handler::commandData.other.c_str());
  printf("\nparameters=%s", IMAP4Handler::commandData.parameters.c_str());
  switch(IMAP4Handler::commandData.type)
  {
    case IMAP4Handler::LOGIN:
      printf("\nLogin");
      break;
    case IMAP4Handler::CLOSE:
      printf("\nClose");
      break;
    case IMAP4Handler::UNMOUNT:
      printf("\nUmount");
      break;
    case IMAP4Handler::LOGOUT:
      printf("\nLogout");
      break;
    case IMAP4Handler::MOUNT:
      printf("\nMount");
      break;
    case IMAP4Handler::SELECT:
      printf("\nSelect");
      break;
    case IMAP4Handler::ADD_MESSAGE:
      printf("\nAdd message");
      break;
    case IMAP4Handler::DELETE_MESSAGE:
      printf("\nDelete message");
      break;
    case IMAP4Handler::UPDATE_MESSAGE:
      printf("\nUpdate message");
      break;
    case IMAP4Handler::EXPUNGE:
      printf("\nExpunge");
      break;
    case IMAP4Handler::SYNC:
      printf("\nSync");
      break;
    case IMAP4Handler::CREATE_FOLDER:
      printf("\nCreate folder");
      break;
    case IMAP4Handler::DELETE_FOLDER:
      printf("\nDelete folder");
      break;
    case IMAP4Handler::SUBFOLDERS:
      printf("\nSubfolders");
      break;
    case IMAP4Handler::NOOP:
      printf("\nNOOP");
      break;
    case IMAP4Handler::NO_COMMANDS:
    default:
      printf("\nNO_COMMANDS");
    break;
  }
  printf("\n-----------------------------\n");
  fflush(stdout);
}

void imap4_signal_progress(string s)
{
  static const char buf = 0x0;

  IMAP4Handler::progressData=string("imap4:")+s;
  ::write(IMAP4Handler::progressSync[1], &buf, 1);

  sem_wait(&IMAP4Handler::threadLock);
}

bool whatIsNew(NetIMAP4 *client)
{
  bool bRet=true;
  char total[100];
  RemoteMailFolder* folder=IMAP4Handler::imapFolder();

  if( !folder)
    return false;

  client->showStatus();
  folder->showStatus();

  // Compare the old status with the new one
  if( client->uidNext()==folder->uidNext() &&
      client->messagesNumber()!=folder->messages() )
  {
    /*
      We have to delete some messages from local folder
      Get all the UID from remote mailbox and compare it with
      the local folder UID
      Insert the deleted UID into the local folder trash list.
      Then call the sync() for the local folder.
    */
    // UID SEARCH ALL but it is better NOT DELETED
    bRet=client->uid((string)"SEARCH NOT DELETED");
    if( !bRet )
      return false;

    for(UIDMap::iterator it=folder->uidJar->rcvList.begin();
        it!=folder->uidJar->rcvList.end(); ++it)
    {
      UIDMap::iterator itFind=client->searchList.find((*it).first);
      if( itFind==client->searchList.end() )
        folder->uidJar->trashList.insert((*it));
    }
  }
  else
  {
    // There are some new messages
    if( 0==folder->uidNext() )
    {
      /*
        We need all the messages because it is first time
        when this folder is accessed.
      */
      bRet=client->uid((string)"SEARCH NOT DELETED");
      if( !bRet )
        return false;
#if IMAP_PROGRESS_SIGNAL
      if( 0==client->searchList.size() )
		    imap4_signal_progress("nomessages");
		  else
		  {
  		  sprintf(total, "messages:%u", client->searchList.size());
  		  imap4_signal_progress(string(total));
		  }
#endif
		
      string uidList;
      unsigned iList=0;
      for(UIDMap::iterator it=client->searchList.begin(); it!=client->searchList.end(); ++it)
      {
        if( !(iList%10) )
        {
          // download the messages
          // UID FETCH it (FLAGS INTERNALDATE UID BODY[HEADER])
          if( uidList.size() )
          {
            bRet=client->uid((string)"FETCH "+uidList+" (FLAGS INTERNALDATE UID BODY[HEADER])");
            if( !bRet )
              return false;
            uidList="";
          }
          uidList.append((*it).first);
        }
        else
        {
          uidList.append(1, ',');
          uidList.append((*it).first);
        }
        iList++;
      }

      // download the messages
      // UID FETCH it (FLAGS INTERNALDATE UID BODY[HEADER])
      if( uidList.size() )
      {
        bRet=client->uid((string)"FETCH "+uidList+" (FLAGS INTERNALDATE UID BODY[HEADER])");
        if( !bRet )
          return false;
      }

      unsigned iCurrent=1;
      for(MessagesListIterator it=client->fetchMessages.begin(); it!=client->fetchMessages.end(); ++it)
      {
#if IMAP_PROGRESS_SIGNAL
  			// signal progress
  			char current[100];
  			sprintf(current, "%u", iCurrent);
  			imap4_signal_progress(string("dl:")+current+":"+total);
#endif
			
  			IMAP4Handler::incomingMessage.uid=(*it).uid;
  			IMAP4Handler::incomingMessage.rcvtime=(*it).rcvtime;
        IMAP4Handler::incomingMessage.message=(*it).message;
        IMAP4Handler::incomingMessage.flags=(*it).flags;
  			
        // send the reciving signal
        char buf;
  			::write(IMAP4Handler::rcvSync[1], &buf, 1);
  			sem_wait(&IMAP4Handler::threadLock);
  			
#if IMAP_PROGRESS_SIGNAL
    		// check for abort signal
    		if(!sem_trywait(&IMAP4Handler::stopThread))
    		  return false;
#endif
        iCurrent++;
      }
    	//Set the status
    	folder->setStatus(client->uidValidity(), client->uidNext(),
                        client->messagesNumber(), client->unseen(),
                        client->recent());
#if IMAP_PROGRESS_SIGNAL
    	//Sync the data using "completed"
    	imap4_signal_progress("completed");
#endif
    }
    else
    {

      // Check for the new messages.
      // UID SEARCH NEW
      bRet=client->uid((string)"SEARCH NEW");
      if( !bRet )
        return false;

#if IMAP_PROGRESS_SIGNAL
      if( 0==client->searchList.size() )
		    imap4_signal_progress("nomessages");
		  else
		  {
  		  sprintf(total, "messages:%u", client->searchList.size());
  		  imap4_signal_progress(string(total));
		  }
#endif
		
      string uidList;
      unsigned iList=0;
      for(UIDMap::iterator it=client->searchList.begin(); it!=client->searchList.end(); ++it)
      {
        if( !(iList%10) )
        {
          // download the messages
          // UID FETCH it (FLAGS INTERNALDATE UID BODY[HEADER])
          if( uidList.size() )
          {
            bRet=client->uid((string)"FETCH "+uidList+" (FLAGS INTERNALDATE UID BODY[HEADER])");
            if( !bRet )
              return false;
            uidList="";
          }
          uidList.append((*it).first);
        }
        else
        {
          uidList.append(1, ',');
          uidList.append((*it).first);
        }
        iList++;
      }

      // download the messages
      // UID FETCH it (FLAGS INTERNALDATE UID BODY[HEADER])
      if( uidList.size() )
      {
        bRet=client->uid((string)"FETCH "+uidList+" (FLAGS INTERNALDATE UID BODY[HEADER])");
        if( !bRet )
          return false;
      }

      unsigned iCurrent=1;
      for(MessagesListIterator it=client->fetchMessages.begin(); it!=client->fetchMessages.end(); ++it)
      {
#if IMAP_PROGRESS_SIGNAL
  			// signal progress
  			char current[100];
  			sprintf(current, "%u", iCurrent);
  			imap4_signal_progress(string("dl:")+current+":"+total);
#endif
			
  			IMAP4Handler::incomingMessage.uid=(*it).uid;
  			IMAP4Handler::incomingMessage.rcvtime=(*it).rcvtime;
        IMAP4Handler::incomingMessage.message=(*it).message;
        IMAP4Handler::incomingMessage.flags=(*it).flags;
  			
        // send the reciving signal
        char buf;
  			::write(IMAP4Handler::rcvSync[1], &buf, 1);
  			sem_wait(&IMAP4Handler::threadLock);
  			
#if IMAP_PROGRESS_SIGNAL
    		// check for abort signal
    		if(!sem_trywait(&IMAP4Handler::stopThread))
    		  return false;
#endif
        iCurrent++;
      }

    	//Set the status
    	folder->setStatus(client->uidValidity(), client->uidNext(),
                        client->messagesNumber(), client->unseen(),
                        client->recent());
#if IMAP_PROGRESS_SIGNAL
    	//Sync the data using "completed"
    	imap4_signal_progress("completed");
#endif

      // Check for deleted messages.
      // UID SEARCH NOT DELETED
      bRet=client->uid((string)"SEARCH NOT DELETED");
      if( !bRet )
        return false;

      for(UIDMap::iterator it=folder->uidJar->rcvList.begin();
          it!=folder->uidJar->rcvList.end(); ++it)
      {
        UIDMap::iterator itFind=client->searchList.find((*it).first);
        if( itFind==client->searchList.end() )
          folder->uidJar->trashList.insert((*it));
      }

      // TODO: check if there are messages which are seen but there aren't in
      // the local folder.
    }
  }
#if IMAP_PROGRESS_SIGNAL
//	imap4_signal_progress("sync");
#endif
  return true;
}

int processIMAPCommand()
{
  char buf = 0x0;
  bool bRet = true;
  unsigned clientState=0;
	IncomingAuthStructure *auth=0;
	
  printf("\nWaiting...!\n");
  fflush(stdout);
  sem_wait(&IMAP4Handler::imap4Command);

  if(IMAP4Handler::commandData.type!=IMAP4Handler::NO_COMMANDS
    && !( (IMAP4Handler::commandData.type == IMAP4Handler::LOGOUT ||
           IMAP4Handler::commandData.type == IMAP4Handler::UNMOUNT)
           && !client)
    )
  {
    printf("\nCommand=%d!\n", IMAP4Handler::commandData.type);
    fflush(stdout);

    // make the connection
    if( !account.size() || account!=IMAP4Handler::commandData.account )
    {
      if( account.size() )
      {
        printf("\nWe need to logout!!!\n");
        fflush(stdout);

        client->logout();
        delete client;
        client=0;
        account="";
      }

      // reload the auth from the Aethera server
  		::write(IMAP4Handler::authSync[1], &buf, 1);
  		sem_wait(&IMAP4Handler::threadLock);
  	  auth=IMAP4Handler::incomingConnectionData;
  	
  	  // connect
  	  if( !client )
  	    client = new NetIMAP4(auth->speed.c_str());
      if( !client->connect(auth->server, auth->port) )
        return true;

      // set the current account
      account=IMAP4Handler::commandData.account;
    	printf("imap4thread: connected.\n");
    	fflush(stdout);
    }

    clientState=client->state();
    // we need to be logged
    if( clientState==NetIMAP4::NON_AUTHENTICATED ||
        clientState==NetIMAP4::LOGOUTED )
    {
      if( !client->login(auth->user, auth->password) )
        return true;
      client->capability();
    }

    clientState=client->state();
    client->clear();
    switch(IMAP4Handler::commandData.type)
    {
      case IMAP4Handler::LOGIN:
//        printf("\nLogin\n");
//        fflush(stdout);
        break;
      case IMAP4Handler::CLOSE:
//        printf("\nClose\n");
//        fflush(stdout);
        if( clientState==NetIMAP4::SELECTED )
          bRet=client->close();
        break;
      case IMAP4Handler::UNMOUNT:
      case IMAP4Handler::LOGOUT:
        // first check if there are other commands in the list
   			::write(IMAP4Handler::checkList[1], &buf, 1);
   			sem_wait(&IMAP4Handler::threadLock);
   			if( IMAP4Handler::emptyList )
   			{
//        printf("\nLogout\n");
//        fflush(stdout);
          IMAP4Handler::cleanCommandData();
          bRet=client->logout();
          delete client;
          client=0;
          account="";
          return true;
   			}
        break;
      case IMAP4Handler::MOUNT:
      case IMAP4Handler::SELECT:
//        printf("\nSelect\n");
//        fflush(stdout);
        // select the mailbox
        if( client->mailbox()!=IMAP4Handler::commandData.mailbox )
          bRet=client->select(IMAP4Handler::commandData.mailbox);
        break;
      case IMAP4Handler::ADD_MESSAGE:
        {
          // we need the selected state
          if( clientState!=NetIMAP4::SELECTED ||
              client->mailbox()!=IMAP4Handler::commandData.mailbox )
            bRet=client->select(IMAP4Handler::commandData.mailbox);
          if( !bRet )
            break;

          // set the UID for the next message
          bRet=client->status("UIDNEXT");
          if( !bRet )
            break;
          char uidNext[100];
          sprintf(uidNext, "%lu", client->uidNext());

          // Add the message
          bRet=client->append(IMAP4Handler::commandData.parameters, client->mailbox());
          if( !bRet )
            break;

          // Fetch the message
          bRet=client->uid((string)"FETCH "+(string)uidNext+(string)" (FLAGS INTERNALDATE UID BODY[HEADER])");
          if( !bRet )
            break;

          if( client->fetchMessages.size() )
          {
            IMAP_MESSAGE fetchMessage=client->fetchMessages.front();
            // Set the message buffer
       			IMAP4Handler::incomingMessage.uid=fetchMessage.uid;
       			IMAP4Handler::incomingMessage.rcvtime=fetchMessage.rcvtime;
            IMAP4Handler::incomingMessage.message=fetchMessage.message;
            IMAP4Handler::incomingMessage.flags=fetchMessage.flags;
            // Make a new message
      			::write(IMAP4Handler::rcvSync[1], &buf, 1);
      			sem_wait(&IMAP4Handler::threadLock);
          }
        }
        break;
      case IMAP4Handler::DELETE_MESSAGE:
        // we need the selected state
        if( clientState!=NetIMAP4::SELECTED ||
            client->mailbox()!=IMAP4Handler::commandData.mailbox )
          bRet=client->select(IMAP4Handler::commandData.mailbox);
        if( !bRet )
          break;

//        printf("\nDeleteMessage - IMAP\n");
//        fflush(stdout);
        bRet=client->uid((string)"STORE " + IMAP4Handler::commandData.parameters +
                        (string)" +FLAGS (\\Deleted)");
        break;
      case IMAP4Handler::UPDATE_MESSAGE:
//        printf("\nUpdate Message\n");
//        fflush(stdout);
        // we need the selected state
        if( clientState!=NetIMAP4::SELECTED ||
            client->mailbox()!=IMAP4Handler::commandData.mailbox )
          bRet=client->select(IMAP4Handler::commandData.mailbox);
        if( !bRet )
          break;

        bRet=client->uid((string)"FETCH " + IMAP4Handler::commandData.parameters +
                        (string)" (FLAGS INTERNALDATE UID BODY[])");
        if( !bRet )
          break;
        if( client->fetchMessages.size() )
        {
          IMAP_MESSAGE fetchMessage=client->fetchMessages.front();
          // Set the message buffer
     			IMAP4Handler::incomingMessage.uid=fetchMessage.uid;
     			IMAP4Handler::incomingMessage.rcvtime=fetchMessage.rcvtime;
          IMAP4Handler::incomingMessage.message=fetchMessage.message;
          IMAP4Handler::incomingMessage.flags=fetchMessage.flags;
          // Update the message
    			::write(IMAP4Handler::updateSync[1], &buf, 1);
    			sem_wait(&IMAP4Handler::threadLock);
        }
        break;
      case IMAP4Handler::EXPUNGE:
//        printf("\nExpunge\n");
//        fflush(stdout);
        // we need the selected state
        if( clientState!=NetIMAP4::SELECTED &&
            client->mailbox()!=IMAP4Handler::commandData.mailbox )
          bRet=client->select(IMAP4Handler::commandData.mailbox);
        if( !bRet )
          break;

        bRet=client->expunge();
        break;
      case IMAP4Handler::SYNC:
//        printf("\nSync\n");
//        fflush(stdout);
        // we need the selected state
        if( clientState!=NetIMAP4::SELECTED ||
            client->mailbox()!=IMAP4Handler::commandData.mailbox )
          bRet=client->select(IMAP4Handler::commandData.mailbox);
        if( !bRet )
          break;

        bRet=client->status();
        bRet=whatIsNew(client);
        break;
      case IMAP4Handler::CREATE_FOLDER:
//        printf("\nCreate folder\n");
//        fflush(stdout);
        bRet=client->create(IMAP4Handler::commandData.mailbox);
        if( bRet )
        {
        	// Check if the view type is genmail
        	// Remove the last '/' used for creating the IMAP folder
        	if( !IMAP4Handler::commandData.other.compare("genmail") )
        	  IMAP4Handler::commandData.mailbox.erase( IMAP4Handler::commandData.mailbox.rfind('/') );
          bRet=client->subscribe(IMAP4Handler::commandData.mailbox);
          // create the folder in Aethera
     			::write(IMAP4Handler::createSync[1], &buf, 1);
     			sem_wait(&IMAP4Handler::threadLock);
        }
        break;
      case IMAP4Handler::DELETE_FOLDER:
//        printf("\nDelete folder\n");
//        fflush(stdout);
        bRet=client->unsubscribe(IMAP4Handler::commandData.mailbox);
        if( bRet )
        {
          bRet=client->delete_(IMAP4Handler::commandData.mailbox);
          if( bRet )
          {
            // delete the folder from Aethera
       			::write(IMAP4Handler::deleteSync[1], &buf, 1);
       			sem_wait(&IMAP4Handler::threadLock);
          }
        }
        break;
      case IMAP4Handler::SUBFOLDERS:
//        printf("\nSubfolders\n");
//        fflush(stdout);
        IMAP4Handler::subfoldersList.clear();
        bRet=client->lsub(IMAP4Handler::commandData.mailbox);
        if(bRet)
        {
          MboxList tempList(client->mboxList);
          // for each folder we will check the status and change the name
          // if the delimiter isn't '/'
	        for(MboxListIterator it=tempList.begin(); it!=tempList.end(); ++it)
	        {
	          bool bRet1=true;
	
	          bRet1=client->list("\"\"", (*it).name);
	          if( bRet1 && client->mboxList.size() )
  	          IMAP4Handler::subfoldersList.push_back( client->mboxList.front() );
	        }
	
	        // if all was ok, send the notification
          // Send the subfolders signal
     			::write(IMAP4Handler::subfoldersSync[1], &buf, 1);
     			sem_wait(&IMAP4Handler::threadLock);
        }
        break;
      case IMAP4Handler::NOOP:
//        printf("\nNOOP\n");
//        fflush(stdout);
        // we need the selected state
        if( clientState!=NetIMAP4::SELECTED ||
            client->mailbox()!=IMAP4Handler::commandData.mailbox )
          bRet=client->select(IMAP4Handler::commandData.mailbox);
        if( !bRet )
          break;

        client->noop();
        bRet=whatIsNew(client);
        break;
      default:
        printf("\nNO_COMMANDS\n");
        fflush(stdout);
      break;
    }
  }

  if(!bRet)
  {
    printf("\nIMAP_ERROR\n");
    showCommand(client);
    fflush(stdout);
    IMAP4Handler::cleanCommandData();
    bRet=client->logout();
    delete client;
    client=0;
    account="";
  }

  // Reset the command
  IMAP4Handler::commandData.type=IMAP4Handler::NO_COMMANDS;

  sem_init(&IMAP4Handler::imap4Command, 0, 0);
  // send the next command signal
  ::write(IMAP4Handler::commandSync[1], &buf, 1);
	sem_wait(&IMAP4Handler::threadLock);
	
  return false;
}

void *imap4_thread(void *args)
{
	printf("imap4thread: starting\n");
	fflush(stdout);

  // reset the connection variables
  client=0;
	account="";
  IMAP4Handler::cleanCommandData();
	
	// process the commands
	while( !processIMAPCommand() )
	  printf("Command processed.\n");
	
  // reset the connection variables
  if(client)
    delete client;
  client=0;
	account="";
	
	// unlock global imap4 semaphore and exit
	sem_post(&IMAP4Handler::imap4Lock);
	printf("imap4thread: exiting\n");
	pthread_exit(0);
}



























