/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <iosynchandler.h>
#include <mailfolder.h>
#include <indexclass.h>
#include <pop3handler.h>
#include <imap4handler.h>
#include <orb.h>
#include <string>
#include <kconfig.h>
#include <messagedescriptor.h>
#include <messagedevice.h>
#include <dateclass.h>
#include <mimecodec.h>

#include <clientvfs.h>
#include "../../plugins/mailfilter/mailfilter_plugin.h"

extern KConfig *GlobalConfig;
extern MailFilter *mailFilter;


IOSyncHandler *IOSyncHandler::thisInstance;

IOSyncHandler *IOSyncHandler::ref()
{
	return thisInstance?thisInstance:(thisInstance=new IOSyncHandler());
}

void IOSyncHandler::dispatchToInbox(const IncomingMessage &msg)
{

  // find folder to create the message
  QCString messageText=MIMECodec::decodeEndLine(QCString(msg.message.c_str()));

  MessageClass message(messageText);

  QString mFolder = mailFilter->messageFolder( &message );
  MailFolder *folder = 0;

  qDebug ( "mFolder : "+mFolder );

  if ( !mFolder.isEmpty() ) {
    folder=ObjectRequestBroker::thisInstance()->mailfolderReference( ClientVFS::thisInstance()->map(mFolder) );
    if ( !foldersToSync.contains( mFolder ) )
      foldersToSync.append(mFolder);
  }

  if ( !folder )
    folder = ObjectRequestBroker::thisInstance()->mailfolderReference("sysmail_inbox");

	if( !folder )
	{
		printf("A fatal error has occured, inbox interface not found. Message discarded.");
		exit(1);
	}
	else
	{
   	// we use sync signal - last param is true!
   	QDateTime rcvTime;
   	rcvTime.setTime_t(msg.rcvtime);
   	IndexClass *idx = folder->createMessage(messageText, msg.uid.c_str(), rcvTime, msg.account.c_str(), &message, true );
   	
   	mailFilter->applyFilter(idx, false);
	}
}

void IOSyncHandler::dispatchMessage(const IMAP_MESSAGE &msg, bool bSync)
{
  RemoteMailFolder *imapFolder=IMAP4Handler::imapFolder();
	if(!imapFolder)
	{
		printf("\nA fatal error has occured, IMAP mailbox interface not found. Message discarded.\n");
	}
	else
	{
		QCString messageText=MIMECodec::decodeEndLine(QCString(msg.message.c_str()));
  	// we use sync signal - last param is true!
  	QDateTime rcvTime;
  	rcvTime.setTime_t(msg.rcvtime);
  	imapFolder->createMessage(messageText, msg.uid.c_str(), rcvTime, msg.account.c_str(),0, bSync, msg.flags);
	}
}

void IOSyncHandler::updateMessage(const IMAP_MESSAGE &msg)
{
  RemoteMailFolder *imapFolder=IMAP4Handler::imapFolder();
	if(!imapFolder)
	{
		printf("A fatal error has occured, IMAP mailbox interface not found. Message discarded.");
	}
	else
	{
		QCString messageText=MIMECodec::decodeEndLine(QCString(msg.message.c_str()));
  	imapFolder->updateMessage(messageText, msg.uid.c_str());
	}
}

void IOSyncHandler::pop3Sync()
{
	MailFolder *inbox=ObjectRequestBroker::thisInstance()->mailfolderReference("sysmail_inbox");
  	
	if(!inbox)
	{
		printf("A fatal error has occured, inbox interface not found. Message discarded.");
	}
	else
	  inbox->sync();
  	
	for ( QStringList::Iterator it = foldersToSync.begin(); it != foldersToSync.end(); ++it ) {
  	MailFolder *folder=ObjectRequestBroker::thisInstance()->mailfolderReference( ClientVFS::thisInstance()->map(*it) );
  	if ( folder )
  	  folder->sync();
  }
  foldersToSync.clear();
}

void IOSyncHandler::imap4Sync()
{
	if(!IMAP4Handler::imapFolder())
	{
		printf("A fatal error has occured, IMAP mailbox interface not found. Message discarded.");
	}
	else
    IMAP4Handler::imapFolder()->sync();
}

void IOSyncHandler::unlinkOutgoing(IndexClass *idx)
{
	GlobalConfig->setGroup("Send Options");
	if(GlobalConfig->readEntry("Save sent")=="Yes")
	{
		// replace info from the extended status
		MessageDevice *dev=new MessageDevice(idx);
		dev->loadDescriptor();
		MessageDescriptor &descriptor=dev->getDescriptor();
		descriptor.extendedStatus.clear();
		descriptor.extendedStatus.append(QString("sent:")+(const char *)DateClass(QDateTime::currentDateTime()).toQCString());
		
		// update status
		descriptor.status="Sent";
		
		// update sent date
		descriptor.sentDate=(const char *)DateClass(QDateTime::currentDateTime()).toQCString();
		
		dev->saveDescriptor();
		delete dev;
		
		// move message in "Sent Mail", if needed
		ObjectRequestBroker::thisInstance()->move("sysmail_outbox/"+idx->getID(), "sysmail_sent");
	}
	else
	{
		// delete message
		ObjectRequestBroker::thisInstance()->remove("sysmail_outbox/"+idx->getID());
	}
}

void IOSyncHandler::updateOutgoing(IndexClass *idx, string status)
{
	MessageDevice *dev=new MessageDevice(idx);
	dev->loadDescriptor();
	MessageDescriptor &descriptor=dev->getDescriptor();
	descriptor.extendedStatus.clear();
	descriptor.extendedStatus.append(QString("not sent:")+status.c_str());
	dev->saveDescriptor();
	delete dev;
}


void IOSyncHandler::createFolder(string &parent, string &folderPath, string& type, string &viewType)
{
  ObjectRequestBroker::thisInstance()->createFolder(parent.c_str(), folderPath.c_str(), type.c_str(), viewType.c_str());
}

void IOSyncHandler::deleteFolder(string &parent, string &folderPath, string& type, string &serverPath)
{
  ObjectRequestBroker::thisInstance()->deleteFolder(parent.c_str(), folderPath.c_str(), type.c_str(), serverPath.c_str());
}











