/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <orb.h>
#include <magellan.h>
#include <mailclasses.h>
#include <indexclass.h>
#include <transactionserver.h>
#include <attributemarshall.h>
#include <conversions.h>
#include <qfileinfo.h>
#include <messagedevice.h>
#include <messagefactory.h>

QString ObjectRequestBroker::createObject(QString folder_url)
{
	if(!exists(folder_url))
	{
		err="Cannot create an object without an existent parent";
		return QString::null;
	}
		
  if(type(folder_url)==Magellan::Message)
  {
		if(isFolder(folder_url))
		{
			return folder_url+"/"+mailfolderReference(folder_url)->createMessage()->getID();
		}
		else
		{
			IndexClass *idx=indexReference(folder_url);
			MessageDevice dev(idx);
			int newPart=dev.createPart();
			return folder_url+"."+QString::number(newPart);
		}
  }
  
  DataCollection *t=folderReference(folder_url);
	
  QString id=t->addEntry();
	
	TransactionServer::thisInstance()->save(t->ref(id));
	
	if(!id.isNull()) ServerNotifier::thisInstance()->objectCreated(folder_url+"/"+id);
	
	return id;
}
