/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <serverrmi.h>
#include <any.h>
#include <servercommgate.h>
#include <commframe.h>
#include <qstring.h>
#include <qdatastream.h>
#include <servercommgate.h>
#include <conversions.h>
#include <rmicalldata.h>
#include <commands.h>

ServerRMI *ServerRMI::thisInstance;

ServerRMI *ServerRMI::ref()
{
	return thisInstance?(thisInstance=new ServerRMI()):thisInstance;
}

void ServerRMI::__RMICall(const RMICallData &data)
{
	CommFrame inFrame;
	
	inFrame.majorRevNo=1;
	inFrame.minorRevNo=1;
	inFrame.requestFrame=true;
	inFrame.serverFrame=true;
	inFrame.deniesReply=true;
	inFrame.hasData=true;
	inFrame.commandCode=MagellanComm::RMICall;
	
	inFrame.extraData=_stream(data);
	
	ServerCommGate::thisInstance()->sendMessage(inFrame);
}

Any ServerRMI::__RMICallback(const RMICallData &data)
{
	CommFrame inFrame, outFrame;
	
	inFrame.majorRevNo=1;
	inFrame.minorRevNo=1;
	inFrame.requestFrame=true;
	inFrame.serverFrame=true;
	inFrame.requestsReply=true;
	inFrame.hasData=true;
	inFrame.commandCode=MagellanComm::RMICall;
	
	inFrame.extraData=_stream(data);
	
	ServerCommGate::thisInstance()->sendMessage(inFrame, outFrame);
	
	return _narrowAny(outFrame.extraData);
}

void ServerRMI::__process(CommFrame &inFrame)
{
	RMICallData data=_narrowRMICallData(inFrame.extraData);
	
	// method switch
	if(data.method=="startSendReceive(QString)")
		startSendReceive(data.param[0].toString());
	else if(data.method=="startSend(QString)")
		startSend(data.param[0].toString());
	else if(data.method=="startReceive(QString)")
		startReceive(data.param[0].toString());
	else if(data.method=="stopPOP3Delivery()")
		stopPOP3Delivery();
	else if(data.method=="setAutoExpunge(bool)")
		setAutoExpunge(data.param[0].toInt());
}

void ServerRMI::__process(CommFrame &inFrame, CommFrame &outFrame)
{
	RMICallData data=_narrowRMICallData(inFrame.extraData);
	
	// method switch
	if(data.method=="getAccountNames(int)")
		outFrame.extraData=_stream(Any(getAccountNames(data.param[0].toInt())));
	else if(data.method=="getDefaultAccount()")
		outFrame.extraData=_stream(Any(getDefaultAccount()));
	else if(data.method=="isAccountActive(QString)")
		outFrame.extraData=_stream(Any(isAccountActive(data.param[0].toString())));
	else if(data.method=="mount(QString)")
		outFrame.extraData=_stream(Any(mount(data.param[0].toString())));
	else if(data.method=="unmount(QString)")
		outFrame.extraData=_stream(Any(unmount(data.param[0].toString())));
	else if(data.method=="subfolders(QString, QString, QString)")
		outFrame.extraData=_stream(Any(subfolders(data.param[0].toString(), data.param[1].toString(), data.param[2].toString())));
}

void ServerRMI::sendPOP3Progress(QString progress)
{
	RMICallData data;
	data.method="sendPOP3Progress(QString)";
	data.pcount=1;
	data.param.append(Any(progress));
	
	__RMICall(data);
}

void ServerRMI::sendSMTPProgress(QString progress)
{
	RMICallData data;
	data.method="sendSMTPProgress(QString)";
	data.pcount=1;
	data.param.append(Any(progress));

	__RMICall(data);	
}

int ServerRMI::getSMTPAction(QString from, QString subject, int size)
{
	RMICallData data;
	data.method="getSMTPAction(QString,QString,int)";
	data.pcount=3;
	data.param.append(Any(from));
	data.param.append(Any(subject));
	data.param.append(Any(size));
	
	return (int)__RMICallback(data);
}

QString ServerRMI::getMailAccountPassword(QString account)
{
	RMICallData data;
	data.method="getMailAccountPassword(QString)";
	data.pcount=1;
	data.param.append(Any(account));
	
	return( __RMICallback(data).operator QString() );
}





