/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <serverrmistub.h>
#include <qstring.h>
#include <qstringlist.h>
#include <accountmanager.h>
#include <pop3handler.h>
#include <smtphandler.h>
#include <imap4handler.h>
#include <localmailfolder.h>

QStringList ServerRMIStub::getAccountNames(int accountType)
{
	return AccountManager::ref()->getAccountNames(accountType);
}

QString ServerRMIStub::getDefaultAccount()
{
	return AccountManager::ref()->getDefaultAccount()->accname;
}

bool ServerRMIStub::isAccountActive(QString account)
{
	Account *acc=AccountManager::ref()->getAccount(account);
	return acc?acc->enabled:false;
}

QString ServerRMIStub::getAccountFromAddress(QString account)
{
	Account *acc=AccountManager::ref()->getAccount(account);
	return acc?QString("\"")+acc->name+"\" "+ acc->from:QString("");
}

QString ServerRMIStub::getAccountReplyToAddress(QString account)
{
	Account *acc=AccountManager::ref()->getAccount(account);
	return acc?QString("\"")+acc->name+"\" "+ acc->reply:QString("");
}

void ServerRMIStub::startSendReceive(QString account)
{
	// debug
	printf("server: RMI call received: startSendReceive(%s)\n", (const char *)account);
	startReceive(account);
	startSend(account);
}

void ServerRMIStub::startSend(QString account)
{
	// debug
	printf("server: RMI call received: startSend(%s)\n", (const char *)account);
	Account *acc=AccountManager::ref()->getAccount(account);
	if(acc)
		SMTPHandler::ref()->startSend(acc);
	else
		printf("server: cannot start SMTPHandler, invalid account\n");
}

void ServerRMIStub::startReceive(QString account)
{
	// debug
	printf("server: RMI call received: startReceive(%s)\n", (const char *)account);
	
	Account *acc=AccountManager::ref()->getAccount(account);
	if(!acc)
		printf("server: cannot start receiving, invalid account (null)\n");
	else
	{
	  switch(acc->type)
	  {
	    case Account::POP3 :
    		POP3Handler::ref()->getMail(acc);
	      break;
	    case Account::IMAP4 :
    		IMAP4Handler::ref()->getMail(acc);
	      break;
	    case Account::UNDEFINE :
	    case Account::MAILBOX :
	    default :
    		printf("server: cannot start receiving, invalid account type\n");
	      break;
	  }
	}
}

void ServerRMIStub::stopPOP3Delivery()
{
	POP3Handler::ref()->stopDelivery();
}

void ServerRMIStub::setAutoExpunge(bool mode)
{
	MailFolder::setAutoExpunge(mode);
}

bool ServerRMIStub::mount(QString url)
{
  return IMAP4Handler::ref()->mount(url);
}

bool ServerRMIStub::unmount(QString url)
{
  return IMAP4Handler::ref()->unmount(url);
}

bool ServerRMIStub::subfolders(QString account, QString mailbox, QString url)
{
  return IMAP4Handler::ref()->subfolders(account, mailbox, url);
}



