/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <licenseframe.h>
#include <videotoolbox.h>
#include <qtextstream.h>
#include <qfile.h>
#include <licence.h>

extern VideoToolBox vtb;

LicenseFrame::LicenseFrame(QWidget *parent, QString name,
	int x, int y, int dx, int dy, int idx) :
	QFrame(parent, name)
{
	index=idx;
	setGeometry(x, y, dx, dy);
	setFrameStyle(0);
	// Creating the continue-cancel buttons
	// The buttons are going to be in the bottom right
	int x,y;
	x=dx-280, y=dy-vtb.fontHeight();
	backButton=vtb.setUpQPushButton(this,"Back",
		80, vtb.fontHeight(), &x, &y);
	x=dx-180, y=dy-vtb.fontHeight();
	continueButton=vtb.setUpQPushButton(this,"Next",
		80, vtb.fontHeight(), &x, &y);
	x=dx-80, y=dy-vtb.fontHeight();
	finishButton=vtb.setUpQPushButton(this,"Cancel",
		80, vtb.fontHeight(), &x, &y);
	// create the frame!
	int DX=0, DY=0;
	QString buffer;
	licenseView= vtb.setUpTextView(this, QFrame::Panel | QFrame::Sunken,
		QColor(255,255,255),
		qembed_findData("licence.txt"),
		dx,dy-2*(vtb.fontHeight()+vtb.offsetY()),DX,DY);
	DY+=dy-2*vtb.fontHeight()-vtb.offsetY();
	radioGroup=new QButtonGroup(this);
	radioGroup->setGeometry(DX,DY,dx,vtb.fontHeight());
	radioGroup->setExclusive(true);
	radioGroup->setFrameStyle(0);
	DY=0;
	DX=40;
	yesButton=vtb.setUpQRadioButton(radioGroup,"I &agree",&DX, &DY);
	DX=dx-40-vtb.stringLength("I don't &agree")-vtb.fontHeight();
	noButton=vtb.setUpQRadioButton(radioGroup,"I &don't agree",&DX, &DY);
	radioGroup->insert(yesButton,1);
	radioGroup->insert(noButton,2);
//	continueButton->setEnabled(false);
	connect(radioGroup, SIGNAL(clicked(int)), this, SLOT(radioClicked(int)));
	connect(continueButton, SIGNAL(clicked()), this, SLOT(continueClicked()));
	connect(finishButton, SIGNAL(clicked()), this, SLOT(finishClicked()));
	connect(backButton, SIGNAL(clicked()), this, SLOT(backClicked()));
}
void LicenseFrame::continueClicked()
{
	QStringList rez;
	rez.append("[License]");
	rez.append(QString("Agreed=")+QString((yesButton->isChecked())?"Yes":"No"));
	emit result(1, index, rez);
	close();
}

void LicenseFrame::finishClicked()
{
	emit result(0, index, QStringList(""));
	close();
}

void LicenseFrame::backClicked()
{
	emit result(2, index, QStringList(""));
	close();
}

void LicenseFrame::radioClicked(int id)
{
	switch(id)
	{
		case 2: // agree
//			continueButton->setEnabled(false);
			break;
		case 1: // don't agree
//			continueButton->setEnabled(true);
			break;
	}
}
