/***************************************************************************
                   pluginframe.cpp  -  the plug in support
                             -------------------
    begin                : Thu Jul  5 17:35:17 EEST 2001
    copyright            : (C) 2001 by Eugen C.
    email                : eug@thekompany.com
 ***************************************************************************/

#include <pluginframe.h>

#include <videotoolbox.h>
#include <kiconloader.h>
#include <definedmessages.h>

#include <qdir.h>
#include <qfiledialog.h>
#include <qfileinfo.h>
#include <qmessagebox.h>
#include <miscfunctions.h>

extern VideoToolBox vtb;

PlugInFrame::PlugInFrame(QWidget *parent, QString name,
	int x, int y, int dx, int dy, int idx) :
	QFrame(parent, name)
{
	index=idx;
	setGeometry(x, y, dx, dy);
	setFrameStyle(0);
	// Creating the continue-cancel buttons
	// The buttons are going to be in the bottom right
	int x,y;
	x=dx-280, y=dy-vtb.fontHeight();
	backButton=vtb.setUpQPushButton(this,"Back",
		80, vtb.fontHeight(), &x, &y);
	x=dx-180, y=dy-vtb.fontHeight();
	continueButton=vtb.setUpQPushButton(this,"Next",
		80, vtb.fontHeight(), &x, &y);
	continueButton->setDefault(true);
	x=dx-80, y=dy-vtb.fontHeight();
	finishButton=vtb.setUpQPushButton(this,"Cancel",
		80, vtb.fontHeight(), &x, &y);
	// create the text
	int DX=5, DY=5;
	QDir d= QDir::home();
	path= d.absPath()+"/PlugIn";
	vtb.setUpFonts(QFont("helvetica",12,QFont::Normal));
	text=vtb.setUpLabelSize(this,"Please choose the path where Aethera "
		"will store the plug ins.",
		dx-vtb.fontHeight()-10, &DX, &DY);
	DY=(dy-vtb.fontHeight()*2-DY)/2 +DY - vtb.fontHeight()/2;
	DX=5;
	edit=vtb.setUpLineEdit(this, dx-DX-5-vtb.fontHeight()-7,vtb.fontHeight(),
		&DX, &DY);
	edit->setText(path);
	browseButton=vtb.setUpQPushButton(this,QString::null,
		vtb.fontHeight(), vtb.fontHeight(), &DX, &DY);
	browseButton->setPixmap(BarIcon("open"));
	connect(browseButton, SIGNAL(clicked()), this, SLOT(browseClicked()));
	connect(backButton, SIGNAL(clicked()), this, SLOT(backClicked()));
	connect(continueButton, SIGNAL(clicked()), this, SLOT(continueClicked()));
	connect(finishButton, SIGNAL(clicked()), this, SLOT(finishClicked()));
}

void PlugInFrame::continueClicked()
{
	QStringList elements=split(edit->text(),'/');
	if(elements[elements.count()-1].length()<1)
		elements.remove(elements.at(elements.count()-1));
	elements.remove(elements.at(elements.count()-1));
	
	QString path=(const char *)edit->text();
	QFileInfo qfi(join(elements,"/"));
	
	printf("TEXT: <%s>\n",(const char *)join(elements,"/"));
	printf("TEXTING: <%s>\n", path.latin1());
	
	if(qfi.isReadable() && qfi.isWritable() && qfi.isExecutable())
	{
		QStringList rez;
		rez.append("[PlugIn Dir]");
		rez.append(QString("Directory=")+edit->text());
		QString str="Exists=";
		QDir d;
		if(d.cd(edit->text(),true))
			rez.append(str+"Yes");
		else
			rez.append(str+"No");
		emit result(ContinueMessage, index, rez);
		close();
		
	  // Create the directory !
	  QDir plugInDir(path);
  	plugInDir.mkdir(path, true);
	}
	else
	{
		QMessageBox::warning(this,"ERROR: Folder creation",
			"<font color=black>&nbsp;&nbsp;&nbsp;&nbsp;The&nbsp;directory&nbsp;you&nbsp;have&nbsp;specified&nbsp;cannot&nbsp;be&nbsp;created (no write permission).<br>&nbsp;&nbsp;&nbsp;&nbsp;Please choose another directory (preferable in your home path) or ask your system administrator for assistance</font>",
			"&Ok");
	}
}

void PlugInFrame::finishClicked()
{
	emit result(CancelMessage, index, QStringList(""));
	close();
}

void PlugInFrame::backClicked()
{
	emit result(BackMessage, index, QStringList(""));
	close();
}

void PlugInFrame::browseClicked()
{
	path=QFileDialog::getExistingDirectory(path) + "PlugIn";
	QFileInfo qfi(path);
	edit->setText(path);
	return;
}


