/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <kconfig.h>
#include <attachmentpane.h>
#include <attachmentpanewidget.h>
#include <qfiledialog.h>
#include <kmimetype.h>
#include <qpopupmenu.h>
#include <sortingwidget.h>
#include <clientvfs.h>
#include <vmailattribute.h>
#include <partobj.h>
#include <datahandlerimpl.h>

extern KConfig *GlobalConfig;
    
AttachmentPane::AttachmentPane(QWidget *parent, const char *name, WFlags f):SortingWidget(parent, name, f)
{
  setChildWidth(100);
  setChildHeight(70);
  viewport()->setBackgroundColor(QColor("white"));
	
	setMultipleSelect(false);
	setAllwaysShowPopup(false);
	
	makeChildPopup();
}

void AttachmentPane::makeChildPopup()
{
  childPopup=new QPopupMenu();
  
  childPopup->insertItem("Open");
  childPopup->insertItem("Save", this, SLOT(slotSaveSelection()));
  childPopup->insertSeparator();
  childPopup->insertItem("Copy");
  childPopup->insertItem("Send to...");
  childPopup->insertSeparator();
  childPopup->insertItem("Properties", this, SLOT(slotEditProperties()));
}

void AttachmentPane::setAddress(const QString &address)
{
	SortingWidget::clear();
	
	_address=address;
	
	VMailAttribute *attr=(VMailAttribute *)ClientVFS::thisInstance()->_fact_ref(_address+".attr", "vmailattribute");
	
	if(attr && attr->sync())
	{
		for(int i=0;i<attr->partCount;i++)
		{
			PartObject *part=(PartObject *)ClientVFS::thisInstance()->_fact_ref(_address+"."+QString::number(i), "part");
			if(part)
			{
				part->sync();
				if(part->partType()=="attachment")
					addChild(new AttachmentPaneWidget(part, this));
			}
			else
			{
				printf("Warning: [AttachmentPane] could not get part object for address %s, part %d, skipping...\n", (const char *)_address, i);
			}
		}
		
		delete attr;
	}
	else
	{
		printf("Warning: [AttachmentPane] could not get message attribute for address %s, discarding...\n", (const char *)_address);
	}
}

void AttachmentPane::saveSelection()
{
  if(isSelectionSingle())
    ((AttachmentPaneWidget *)getSelection().at(0))->save();
}

void AttachmentPane::editProperties()
{
  if(isSelectionSingle())
    ((AttachmentPaneWidget *)getSelection().at(0))->editProperties();
}

void AttachmentPane::slotSaveSelection()
{
	saveSelection();
}

void AttachmentPane::slotEditProperties()
{
	editProperties();
}
