/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <groupview.h>
#include <kconfig.h>
#include <qdict.h>
#include <grouptileview.h>
//#include <grouplistview.h>
#include <mailer.h>
#include <templateview.h>
#include <miscfunctions.h>
#include <vfolder.h>

extern KConfig *GlobalConfig;

GroupView::GroupView(VFolder *vfolder, QWidget *parent, const char *name):QWidget(parent, name),TemplateView(vfolder)
{
  main_layout=new QHBoxLayout(this);
//  listView=new GroupListView(vfolder, this);
  tileView=new GroupTileView(vfolder, this);
  tileView->setChildFixedHeight(false);
  tileView->enableWidthResize(true);
  tileView->viewport()->setBackgroundColor(QColor("white"));
  tileView->setChildWidth(80);
  tileView->setChildHeight(80);
//  tileView->setXSpacing(10);
//  tileView->setYSpacing(10);
//  listView->hide();
  tileView->hide();
  
  populateViews();
  
  GlobalConfig->setGroup("Groups");
/*
  if(GlobalConfig->readEntry("View mode")=="list")
  {
    mode=List;
    main_layout->addWidget(listView);
    listView->show();
    main_layout->activate();
  }
  else
*/
  {
    mode=Tile;
    main_layout->addWidget(tileView);
    tileView->show();
    main_layout->activate();
  }
}

GroupView::~GroupView()
{
  delete(main_layout);
//  delete(listView);
  delete(tileView);
}

void GroupView::toggleDisplayMode()
{
  GlobalConfig->setGroup("Groups");
  if(mode==List)
  {
    GlobalConfig->writeEntry("View mode", "tile");
//    listView->hide();
    mode=Tile;
    delete(main_layout);
    main_layout=new QHBoxLayout(this);
    main_layout->addWidget(tileView);
    tileView->show();
    main_layout->activate();
  }
/*
  else
  {
    GlobalConfig->writeEntry("View mode", "list");
    tileView->hide();
    mode=List;
    delete(main_layout);
    main_layout=new QHBoxLayout(this);
    main_layout->addWidget(listView);
    listView->show();
    main_layout->activate();
  }
*/
}

void GroupView::populateViews()
{
}

void GroupView::addGroup(const QString &)
{
}

void GroupView::removeGroup(const QString &)
{
  // remove Group from the tile view
  
  // remove Group from the list view
}

void GroupView::update()
{
}

/*
GroupListView *GroupView::getListView()
{
//	return listView;
}
*/
GroupTileView *GroupView::getTileView()
{
	return tileView;
}

void GroupView::deleteSelection()
{
	tileView->deleteSelection();
}

int GroupView::copySelection()
{
	return tileView->copySelection();
}

int GroupView::cutSelection()
{
	return tileView->cutSelection();
}

void GroupView::paste()
{
	tileView->paste();
}

void GroupView::moveSelectionTo()
{
	tileView->moveSelectionTo();
}

void GroupView::copySelectionTo()
{
	tileView->copySelectionTo();
}

void GroupView::newObject()
{
	tileView->newObject();
}

void GroupView::openSelection()
{
	tileView->openSelection();
}

void GroupView::selectAll()
{
	tileView->selectAll();
}
