/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef __MailListView__
#define __MailListView__

#include <elistview.h>
#include <qpopupmenu.h>
#include <qlist.h>
#include <qevent.h>
#include <qpoint.h>
#include <mailer.h>
#include <vfolder.h>
#include <templateview.h>
#include <datahandlerimpl.h>

class IndexMailItem;

class MailListView : public EListView, public TemplateView, public DataHandlerImpl
{
	Q_OBJECT
	public:
		MailListView(VFolder *folder, QWidget *parent=0, const char *name=0, int t=mail);
		~MailListView();

		void arrangeColumns();
		void placeSelection();

		QPopupMenu *getPopup() { return listpopup; }
		int getType() { return type; }

		// reimplemented/added from DataHandlerImpl
		QList<DataWidget> getSelection();
		QStringList selectedPaths();
		bool isSelectionMultiple();
		bool isSelectionEmpty();
		IndexMailItem *firstSelected();
		void deleteSelection();
		void editProperties();
		void openSelection();
		void saveSelection();
		void selectAll();
		void selectNone();
		void update() {};
	public slots:
		void toggleFlag();
		void markUnread();
		void markRead();
		void markAllRead();
		void markAllUnread();
		void reply();
		void replyAll();
		void forward();
		void forwardInline();
		void forwardQuoted();
		void forwardAsAttachment();
		
		// Qt workaround on virtual slots
		void slotEditProperties();
		void slotDeleteSelection();
		void slotCopySelection();
		void slotCutSelection();
		void slotPaste();
		void slotSaveSelection();
		void slotOpenSelection();
	private slots:
		void showPopup(QListViewItem *, const QPoint &, int);
	protected:
		virtual void contentsMouseMoveEvent(QMouseEvent *e);
		virtual void contentsMousePressEvent(QMouseEvent *e);
		virtual void contentsMouseReleaseEvent(QMouseEvent *e);
	private:
		int type, ncols;
		int rsize[8];
		bool can_drag;
		int selected;
		bool pressed;
		bool released;
		int press_x, press_y;
		QPopupMenu *listpopup;
		bool is_cut;
		bool transaction;
		bool m_isDragging;
};

#endif

