/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

/*

This file includes the definition of the so-called Tile Classes.
There are two kinds of objects defined here: TileWidget and SortingWidget.

A SortingWidget is a GUI object which contains and manages a collection of TileWidgets.
It can automatically arrange, sort, create, drag, copy, paste, display right-click menus etc. on its children.

They are pure classes, and they must be inherited to become useful.

*/

#ifndef __TileWidget__
#define __TileWidget__

#include <stdio.h>
#include <qwidget.h>
#include <qstring.h>
#include <qlist.h>
#include <qpopupmenu.h>
#include <qevent.h>
#include <qscrollview.h>
#include <datawidget.h>

class SortingWidget;

class TileWidget : public QFrame, public DataWidget
{
  Q_OBJECT
  public:
    // Creates a TileWidget object (either empty or from the clipboard).
    TileWidget(SortingWidget *parent, const char *name=0);

    // Destroys a TileWidget object
    virtual ~TileWidget();
    			
    // Returns the n-th sorting key value; the default implementation always returns QString::null.
    virtual QString key(int number);

    // Returns the number of sorting keys; the default implementation returns 0.
    virtual int keyCount();

    // Returns the n-th sorting key name; the default implementation returns QString::null
    // Please note that for the same type of objects this value should remain the same for all instances.
    virtual QString keyName(int number);
};

#endif
