/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * $Id: todowidget.cpp,v 1.4 2001/05/19 09:45:55 alex Exp $
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <kiconloader.h>
#include <qframe.h>

#include <todowidget.h>

#define TITLE_COLOR "white"

ToDoWidget::ToDoWidget(QWidget *parent, const char *name):QWidget(parent, name)
{
  l=new QVBoxLayout(this, 0, -1, "ToDoWidget::QVBoxLayout");
  title=new QLineEdit(this, "title");
  title->setText("Click here to add a new item");
  title->setFixedHeight(20);
  title->setFont(QFont("helvetica", 12));
  //title->setEnabled(false);
  title->installEventFilter(this);
  l->addWidget(title);
  body=new WArray(this, "body");
  body->setRowHeight(22);
  body->setNumCols(2);
  body->setColumnWidth(0, 25);
  body->setColumnWidth(1, 600);
  body->installEventFilter(this);
  l->addWidget(body);
  l->activate();
  setIcon(BarIcon("todo"));
  setCaption("TODO: sample");
  edit_mode=false;
  current_entry=-1;
  connect(title, SIGNAL(returnPressed()), this, SLOT(updateEntry()));
  connect(title, SIGNAL(escapePressed()), this, SLOT(discardChanges()));
}

ToDoWidget::~ToDoWidget()
{
  delete(l);
  delete(title);
  delete(body);
}

bool ToDoWidget::eventFilter(QObject *o, QEvent *e)
{
  if(e->type()==QEvent::MouseButtonPress || e->type()==QEvent::MouseButtonDblClick)
  {
    QMouseEvent *me=(QMouseEvent *)e;
    QPoint p=body->mapFromGlobal(me->globalPos());
    current_entry=p.y()>0?p.y()/22:-1;
    printf("Mouse clicked, y coord:%d\n", p.y());
    if(o==title && edit_mode==false)
    {
      //title->setEnabled(true);
      edit_mode=true;
    }
   }
  return false;
}

void ToDoWidget::addEntry(QString t)
{
  CheckBox *e_check=new CheckBox(body, BarIcon("check-empty"), BarIcon("check-clicked"),
      BarIcon("check-full"));
  int cline=body->numActiveRows();
  body->setNumActiveRows(cline+1);
  body->insertWidget(cline, 0, e_check, true, true);
  QLabel *e_text=new QLabel(t, body);
  e_text->setBackgroundColor(QColor("white"));
  e_text->setFixedHeight(20);
  e_text->setFrameStyle(QFrame::NoFrame);
  body->insertWidget(cline, 1, e_text);
  e_check->installEventFilter(this);
  e_text->installEventFilter(this);
  checkList.append(e_check);
  textList.append(e_text);
  connect(e_check, SIGNAL(toggled(bool)), this, SLOT(updateText(bool)));
}

void ToDoWidget::updateEntry()
{
	//if(current_entry==-1)
	if(!title->text().isEmpty())
		addEntry(title->text());
	title->setText("Click here to add a new item");
	//title->setEnabled(false);
	edit_mode=false;
}

void ToDoWidget::discardChanges()
{
	title->setText("Click here to add a new item");
	//title->setEnabled(false);
	edit_mode=false;
}

void ToDoWidget::updateText(bool t)
{
  printf("Update text: current item:%d\n", current_entry);
  if ( (current_entry != -1) && (static_cast<unsigned int>(current_entry) < textList.count()) )
  {
    QFont f=textList.at(current_entry)->font();
    f.setStrikeOut(t);
    textList.at(current_entry)->setFont(f);
  }
}

CheckBox::CheckBox(QWidget *parent, const QPixmap &empty, const QPixmap &clicked, const QPixmap
    &full):QLabel(parent)
{
	setFixedSize(empty.width(), empty.height());
	state=false;
	pressed=false;
	p1=empty;
	p2=clicked;
	p3=full;
	setPixmap(p1);
}

void CheckBox::mousePressEvent(QMouseEvent *)
{
	setPixmap(p2);
	pressed=true;
}

void CheckBox::mouseReleaseEvent(QMouseEvent *e)
{
  if(e->x()<width() && e->x()>=0 && e->y()<height() && e->y()>=0 && pressed)
  {
    state=!state;
    emit(toggled(state));
  }
  if(state)
    setPixmap(p3);
  else
    setPixmap(p1);
  pressed=false;
}
