#ifndef UICOMPONENT_H
#define UICOMPONENT_H

#include <qstring.h>

/** what needs a UI component for Aethera UI.*/
class UIComponent
{
  public:
    // Constructor and destructor
    UIComponent(unsigned uId, const char* sId, const char* folder, const char* icon=0, const char* toolbar=0);
    ~UIComponent();

    // Public methods
    /** Get the id number.*/
    unsigned idNumber() const;
    /** Get the id name.*/
    QString idName() const;

    // Public attributes
    /** The name of the icon image file.*/
    QString iconName;
    /** The name of root folder.*/
    QString folderName;
    /** The toolbar name.*/
    QString toolbarName;

  private:
    /** Disable the default constructor.*/
    UIComponent();
    /** Disable the default copy constructor.*/
    UIComponent( UIComponent& );

    /** The id number, it will be used like a key into a QMap.*/
    unsigned _IdNumber;
    /** The id string, it will be used like a key into a QDict.*/
    QString _IdName;
};

#endif



