/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <metaline.h>
#include <attendee.h>
#include <stdio.h>

#ifdef IDSTRING
	#undef IDSTRING
#endif
#define IDSTRING	"Attendee: "

#define DEBUG_ATTENDEE

Attendee::Attendee(MetaLine *ml)
{
#ifdef DEBUG_ATTENDEE
	printf(IDSTRING"Entering the constructor\n");
#endif
	informationUpdated=false;
	sourceLine=ml;
	// initializing the fields with the default values
	attendee=ml->getContent();
#ifdef DEBUG_ATTENDEE
	printf(IDSTRING"Attendee is: \"%s\"\n",(const char *)attendee);
#endif
	// now let's parse the bunch of qualities....
	delegatedFrom="";
	delegatedTo="";
	sentBy="";
	directory="";
	language="";
	calUserType="INDIVIDUAL";
	members.clear();
	partStat="NEEDS-ACTION";
	role="REQ-PARTICIPANT";
	rsvp=false;
	#define quality	(*(ml->getQuality()))
	if(ml->getQuality()==NULL)
	{
		printf(IDSTRING"Warning: Quality is NULL\n");
		return;
	}
	else
	{
		if(quality["DELEGATED-FROM"].content().count()!=0)
		{
			delegatedFrom=quality["DELEGATED-FROM"].content()[0].remove(0,1);
			delegatedFrom.remove(delegatedFrom.length()-1,1);
#ifdef DEBUG_ATTENDEE
			printf(IDSTRING"Delegated from: \"%s\"\n",(const char *)delegatedFrom);
#endif
		}
		if(quality["DELEGATED-TO"].content().count()!=0)
		{
			delegatedTo=quality["DELEGATED-TO"].content()[0].remove(0,1);
			delegatedTo.remove(delegatedTo.length()-1,1);
#ifdef DEBUG_ATTENDEE
			printf(IDSTRING"Delegated to: \"%s\"\n",(const char *)delegatedTo);
#endif
		}
		if(quality["SENT-BY"].content().count()!=0)
		{
			sentBy=quality["SENT-BY"].content()[0].remove(0,1);
			sentBy.remove(sentBy.length()-1,1);
#ifdef DEBUG_ATTENDEE
			printf(IDSTRING"Sent by: \"%s\"\n",(const char *)sentBy);
#endif
		}
		if(quality["DIRECTORY"].content().count()!=0)
		{
			directory=quality["DIRECTORY"].content()[0].remove(0,1);
			directory.remove(directory.length()-1,1);
#ifdef DEBUG_ATTENDEE
			printf(IDSTRING"Directory: \"%s\"\n",(const char *)directory);
#endif
		}
		if(quality["LANGUAGE"].content().count()!=0)
		{
			language=quality["LANGUAGE"].content()[0];
#ifdef DEBUG_ATTENDEE
			printf(IDSTRING"Language: \"%s\"\n",(const char *)language);
#endif
		}
		if(quality["ROLE"].content().count()!=0)
		{
			role=quality["ROLE"].content()[0];
#ifdef DEBUG_ATTENDEE
			printf(IDSTRING"Role: \"%s\"\n",(const char *)role);
#endif
		}
		if(quality["PARTSTAT"].content().count()!=0)
		{
			partStat=quality["PARTSTAT"].content()[0];
#ifdef DEBUG_ATTENDEE
			printf(IDSTRING"Participation Status: \"%s\"\n",(const char *)partStat);
#endif
		}
		if(quality["CUTYPE"].content().count()!=0)
		{
			calUserType=quality["CUTYPE"].content()[0];
#ifdef DEBUG_ATTENDEE
			printf(IDSTRING"Calendar user type: \"%s\"\n",(const char *)calUserType);
#endif
		}
		if(quality["RSVP"].content().count()!=0)
		{
			if(quality["RSVP"].content()[0].find("TRUE",0,false)!=-1)
				rsvp=true;
			else
				rsvp=false;
#ifdef DEBUG_ATTENDEE
			printf(IDSTRING"RSVP: \"%d\"\n",rsvp);
#endif
		}
		if(quality["MEMBER"].content().count()!=0)
		{
			members=quality["MEMBER"].content();
			// getting rid of quotes...
			for(int i=0;i<members.count();i++)
			{
				members[i].remove(0,1);
				members[i].remove(members[i].length()-1,1);
			}
#ifdef DEBUG_ATTENDEE
			printf(IDSTRING"Members: \"%d\"\n",members.count());
			for(int i=0;i<members.count();i++)
			{
				printf(IDSTRING"Members[%d]: \"%s\"\n",i,(const char *)members[i]);
			}
#endif
		}
	}
}
void Attendee::setAttendee(QString newElem="")
{
	if(newElem.isEmpty()) return;
	attendee=newElem;
	informationUpdated=true;
}
void Attendee::setDelegatedFrom(QString newElem="")
{
	delegatedFrom=newElem;
	informationUpdated=true;
}
void Attendee::setDelegatedTo(QString newElem="")
{
	delegatedTo=newElem;
	informationUpdated=true;
}
void Attendee::setSentBy(QString newElem="")
{
	sentBy=newElem;
	informationUpdated=true;
}
void Attendee::setDirectory(QString newElem="")
{
	directory=newElem;
	informationUpdated=true;
}
void Attendee::setLanguage(QString newElem="")
{
	language=newElem;
	informationUpdated=true;
}
void Attendee::setCalUserType(QString newElem="")
{
	if(newElem.isEmpty()) newElem="INDIVIDUAL";
	calUserType=newElem;
	informationUpdated=true;
}
void Attendee::appendMember(QString Element="")
{
	members.append("\""+Element+"\"");
	informationUpdated=true;
}
void Attendee::clearMembers()
{
	members.clear();
	informationUpdated=true;
}
void Attendee::removeMember(QString Element="")
{
	for(int i=0;i<members.count();i++)
		if(members[i].find(Element,0,false)!=-1)
		{
			members.remove(members.at(i)),
			i=members.count()+3;
		}
	informationUpdated=true;
}
void Attendee::setPartStat(QString ps="")
{
	if(ps.isEmpty()) ps="NEEDS-ACTION";
	partStat=ps;
	informationUpdated=true;
}
void Attendee::setRole(QString r="")
{
	if(r.isEmpty()) r="REQ-PARTICIPANT";
	role=r;
	informationUpdated=true;
}
void Attendee::setRsvp(bool r=false)
{
	rsvp=r;
	informationUpdated=true;
}
QString Attendee::recompose()
{
	QString result="ATTENDEE";
	if(!delegatedFrom.isEmpty())
		result.append(";DELEGATED-FROM=\""+delegatedFrom+"\"");
	if(!delegatedTo.isEmpty())
		result.append(";DELEGATED-TO=\""+delegatedTo+"\"");
	if(!sentBy.isEmpty())
		result.append(";SENT-BY=\""+sentBy+"\"");
	if(!directory.isEmpty())
		result.append(";DIRECTORY=\""+directory+"\"");
	if(!language.isEmpty())
		result.append(";LANGUAGE="+language);
	if(!role.isEmpty())
		result.append(";ROLE="+role);
	if(!partStat.isEmpty())
		result.append(";PARTSTAT="+partStat);
	if(!calUserType.isEmpty())
		result.append(";CUTYPE="+calUserType);
	if(rsvp)
		result.append(";RSVP=TRUE");
	if(members.count())
	{
		result.append(";MEMBER=\""+members[0]+"\"");
		for(int i=1;i<members.count();i++)
			result.append(",\""+members[i]+"\"");
	}
	result.append(":\""+attendee+"\"");
	return result;
}




