/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <valarm.h>
#include <miscfunctions.h>
#include <stdio.h>
#include <toolbox.h>
#include <stdlib.h>

// whan i have only one occurence: (*mObj)["FN"].getContent()
// otherwise:
//	QValueList<int> matches;
//	matches=mObj->query("version");
//	// get the first one!
//	return mObj->getLines().at(matches[0])->getContent();

//ACTION:		required	1 		occurence
//TRIGGER:	required	1 		occurence
//DURATION:	optional	0/1 	occurences
//REPEAT:		optional	0/1 	occurences

#define IDSTRING "VAlarm: "

#define DEBUG_VALARM

extern Toolbox tb;

bool VAlarm::setBuffers()
{
	switch(alarmType)
	{
		case Audio: 		return setBuffersAudio();
		case Email: 		return setBuffersEmail();
		case Display: 	return setBuffersDisplay();
		case Procedure: return setBuffersProcedure();
		default:
			printf(IDSTRING"Unknown alarm type. Set to default (Display).");
			return setBuffersDisplay();
	}
}
bool VAlarm::setBuffersAudio()
{
	buffer=NULL;
	bufferType=VAlarm::Empty;
	QValueList<int> matches;
	matches=object->query("attach");
	if(matches.count()==0)
		return false;
	#define Action object->getLines().at(matches[0])->getContent()
//	#warning TODO:   We support now ONLY one type of data.
//	#warning TODO:   Teddy, you will have to decide which type of data you want
//	#warning TODO: when you implement the act* functions for it.
	buffer=&Action;
	
	// here we consider that bufer contains an URI referring to the object
	// this includes the object attached to the e-mail case (cid:...)
	bufferType=VAlarm::URI;
	#undef Action
#ifdef DEBUG_VALARM
	printf(IDSTRING"Attachment \"%s\"\n",(const char *)(*buffer));
#endif
	return true;
}
bool VAlarm::setBuffersEmail()
{
	buffer=NULL;
	bufferType=VAlarm::Empty;
	QValueList<int> matches;
	matches=object->query("description");
	if(matches.count()==0)
		return false;
	#define Description object->getLines().at(matches[0])->getContent()
	buffer=&Description;
	matches=object->query("summary");
	if(matches.count()==0)
		return false;
	#define Summary object->getLines().at(matches[0])->getContent()
	summary=&Summary;
	bufferType=VAlarm::Text;
	// now let's get the attendees
	matches=object->query("attendee");
	if(matches.count()==0)
		return false;
	#define Attendee(idx) object->getLines().at(matches[idx])->getContent()
	attendees="";
	for(int i=0;i<matches.count();i++)
	{
		if(i) attendees.append(", ");
		attendees+=Attendee(i);
	}
	attendees=remove(attendees,"mailto:");
#ifdef DEBUG_VALARM
	printf(IDSTRING" Subject: \"%s\"\n",(const char *)(*summary));
	printf(IDSTRING" To: <%s>\n",(const char *)attendees);
	printf(IDSTRING" Content: \"%s\"\n",(const char *)(*buffer));
#endif
	#undef Description
	#undef Summary
	#undef Attendee
	return true;
}
bool VAlarm::setBuffersDisplay()
{
	QValueList<int> matches;
	matches=object->query("description");
	if(matches.count()==0)
		return false;
	#define Action object->getLines().at(matches[0])->getContent()
	buffer=&Action;
	bufferType=VAlarm::Text;
	#undef Action
#ifdef DEBUG_VALARM
	printf(IDSTRING"Will display \"%s\"\n",(const char *)(*buffer));
#endif
	return true;
}
bool VAlarm::setBuffersProcedure()
{
	#define Attach object->getLines().at(matches[0])->getContent()
	#define Description object->getLines().at(matches[0])->getContent()
	buffer=NULL;
	bufferType=VAlarm::Empty;
	QValueList<int> matches;
	matches=object->query("attach");
	if(matches.count()==0)
		return false;
	buffer=&Attach;
	matches=object->query("description");
	if(matches.count()!=0)
		summary=&Description;
	bufferType=VAlarm::URI;
	#undef Attach
	#undef Description
#ifdef DEBUG_VALARM
	printf(IDSTRING"Attachment \"%s\"\n",(const char *)(*buffer));
	printf(IDSTRING"Will show in a window \"%s\"\n",(const char *)(*summary));
#endif
	return true;
}

bool VAlarm::setAlarmType()
{
	alarmType=Unknown;
	QValueList<int> matches;
	matches=object->query("action");
	if(matches.count()==0)
		return false;
	#define Action object->getLines().at(matches[0])->getContent()
	if(Action.find("audio",0,false)!=-1)
		alarmType=VAlarm::Audio;
	else if(Action.find("email",0,false)!=-1)
		alarmType=VAlarm::Email;
	else if(Action.find("display",0,false)!=-1)
		alarmType=VAlarm::Display;
	else if(Action.find("procedure",0,false)!=-1)
		alarmType=VAlarm::Procedure;
#ifdef DEBUG_VALARM
	printf(IDSTRING"The alarm is type %d=%s\n", alarmType,
		(const char *)Action);
#endif
	#undef Action
	return true;
}

bool VAlarm::setDuration()
{
	// the duration *HAS* to be offset, so I will not check for absolute time
	QValueList<int> matches;
	matches=object->query("duration");
	// if i don't have duration, then... is ok
	if(matches.count()==0)
		return false;
	#define Duration object->getLines().at(matches[0])->getContent()
	Toolbox::IntervalType intervalType;
	duration=tb.getDateTimeOffset(Duration,intervalType);
	if(intervalType==Toolbox::BeforeTime) duration=-duration;
#ifdef DEBUG_VALARM
		printf(IDSTRING"Alarm is to be triggered after %ld seconds\n", duration);
#endif
	return true;
}
bool VAlarm::setRepeat()
{
	QValueList<int> matches;

	repeat=-1; // infinite repeats
	matches=object->query("repeat");
	// if i don't have repeat, then... is ok
	if(matches.count()==0)
		return true;
	#define Repeat object->getLines().at(matches[0])->getContent()
	repeat=atoi((const char *)Repeat);
#ifdef DEBUG_VALARM
		printf(IDSTRING"Alarm is to be repeated %d times\n", repeat);
#endif
	return true;
}
bool VAlarm::setTime()
{
  QString triggerValue;
	QValueList<int> matches;
	relativeTrigger=0;
	// first look for an absolute trigger (means autonomous valarm)
	matches=object->query("trigger","value=date-time");
	if(matches.count()!=0 &&
		object->getLines().at(matches[0])->getQuality())
	{
		triggerValue=object->getLines().at(matches[0])->getContent();
#ifdef DEBUG_VALARM
		printf(IDSTRING"Absolute trigger is set to be @ (%s)\n",
				(const char *)triggerValue);
#endif
		Toolbox::TimeZone timeZone;
		absoluteTrigger=tb.getDateTime(triggerValue,timeZone);
//		#warning TODO: correlation with timezones
#ifdef DEBUG_VALARM
		printf(IDSTRING"         Trigger is set to be @ (%s)\n",
				(const char *)absoluteTrigger.toString());
#endif
	}
	else
	{
		matches=object->query("trigger");
		if(matches.count()==0)
		{
			printf(IDSTRING"Error: Invalid format. The object should be erased\n");
			return false;
		}
		triggerValue=object->getLines().at(matches[0])->getContent();
#ifdef DEBUG_VALARM
		printf(IDSTRING"Relative trigger is set to be @ (%s)\n",
				(const char *)triggerValue);
#endif
		Toolbox::IntervalType intervalType;
		relativeTrigger=tb.getDateTimeOffset(triggerValue,intervalType);
		if(intervalType==Toolbox::BeforeTime) relativeTrigger=-relativeTrigger;
	}
	return true;
}


void VAlarm::setAbsoluteTime(QDateTime absdate)
{
	QDateTime temp;
	temp.setDate(absdate.date());
	temp.setTime(absdate.time());
#ifdef DEBUG_VALARM
	printf(IDSTRING"sAT    Date: %s\n",(const char *)temp.date().toString());
	printf(IDSTRING"sAT    Time: %s\n",(const char *)temp.time().toString());
#endif
	absoluteTrigger.setDate(temp.addSecs(relativeTrigger).date());
	absoluteTrigger.setTime(temp.addSecs(relativeTrigger).time());
	absoluteTrigger.addSecs(relativeTrigger);
	relativeTrigger=0;
#ifdef DEBUG_VALARM
	printf(IDSTRING"sAT    Date: %s\n",(const char *)absoluteTrigger.toString());
#endif
}

bool VAlarm::updateTrigger()
{
	// first let's test if we still have something to update
	if(repeat==0)
		return false;
	if(repeat>0) repeat--;
	QDateTime temp;
	temp.setDate(absoluteTrigger.date());
	temp.setTime(absoluteTrigger.time());
	absoluteTrigger.setDate(temp.addSecs(duration).date());
	absoluteTrigger.setTime(temp.addSecs(duration).time());
#ifdef DEBUG_VALARM
	printf(IDSTRING"(up)Date: %s\n",(const char *)absoluteTrigger.toString());
#endif
	return true;
}
bool VAlarm::initTrigger(QDateTime present)
{
	// will update the trigger until it is greater than present or is exhausted
#ifdef DEBUG_VALARM
	printf(IDSTRING"init: begin: present Date: %s\n",
			(const char *)present.toString());
	printf(IDSTRING"init: begin: stored  Date: %s\n",
			(const char *)absoluteTrigger.toString());
#endif
	bool flag=true;
	while( present>absoluteTrigger && flag) flag=updateTrigger();
#ifdef DEBUG_VALARM
	printf(IDSTRING"init: end: present Date: %s\n",
			(const char *)present.toString());
	printf(IDSTRING"init: end: stored  Date: %s\n",
			(const char *)absoluteTrigger.toString());
#endif
	return flag;
}



VAlarm::VAlarm(MetaObject *mo=NULL)
{
	hasErrors=true;
	buffer=summary=NULL;
	attendees=QString::null;
	object=mo;
	if(!setAlarmType())
	{
		printf(IDSTRING"Error while parsing alarm type. "
				"This object should be deleted\n");
		return;
	}
	if(!setBuffers())
	{
		printf(IDSTRING"Error while parsing the buffers. "
				"This object should be deleted\n");
		return;
	}
	if(!setTime())
	{
		printf(IDSTRING"Error while setting the time. "
				"This object should be deleted\n");
		return;
	}
	int count=setRepeat()+setDuration();
	if(count==1)
	{
		printf(IDSTRING"Error while setting the repeat/duration. "
				"This object should be deleted\n");
		return;
	}
	hasErrors=false;
}

bool VAlarm::act()
{
	switch(alarmType)
	{
		case Audio: 		return actAudio();
		case Email: 		return actEmail();
		case Display: 	return actDisplay();
		case Procedure: return actProcedure();
		default:
			printf(IDSTRING"Unknown alarm type. Set to default (Display).");
			return actDisplay();
	}
    return true;
}

bool VAlarm::actAudio()
{
	// use "buffer"=the audio file
	printf(IDSTRING"Beeping: %s\n", (const char *)buffer);
//	#warning TODO: actAudio - here should play the content of "buffer"
    return true;
}
bool VAlarm::actEmail()
{
	// use "buffer"		=	mail content
	//     "summary"	=	mail subject
	//     "attendees"= mail receivers
	printf(IDSTRING"Sending mail....\n");
//	#warning TODO: actEmail - here should send some e-mails
    return true;
}
bool VAlarm::actDisplay()
{
	// use "buffer" = display text content
	printf(IDSTRING"+----------------------------------+\n");
	printf(IDSTRING"| Hey! %s |\n",(const char *)buffer);
	printf(IDSTRING"+----------------------------------+\n");
//	#warning TODO: actDisplay - here should show a dialogbox
    return true;
}
bool VAlarm::actProcedure()
{
	// use "buffer"		=	proggie to be run
	//     "summary"	=	proggie description (dialogbox with it)
	printf(IDSTRING"+----------------------------------+\n");
	printf(IDSTRING"| Hey! %s |\n",(const char *)summary);
	printf(IDSTRING"+----------------------------------+\n");
	printf(IDSTRING"Running %s...\n",(const char *)buffer);
//	#warning TODO: actProcedure - here should run a proggie
    return true;
}

QString VAlarm::recompose(AlarmStyle style)
{
	return object->recompose();
}





